/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegistryManager {
    private static final Map<Item, String> ITEM_NAMES = new ConcurrentHashMap<Item, String>();
    private static final Map<Block, String> BLOCK_NAMES = new ConcurrentHashMap<Block, String>();
    private static final Map<String, Optional<Predicate<ItemStack>>> NAMED_ITEM_TAGS = new ConcurrentHashMap<String, Optional<Predicate<ItemStack>>>();
    private static final Map<String, Optional<Predicate<BlockState>>> NAMED_BLOCK_TAGS = new ConcurrentHashMap<String, Optional<Predicate<BlockState>>>();
    private static final Map<String, Optional<Predicate<Biome>>> NAMED_BIOME_TAGS = new ConcurrentHashMap<String, Optional<Predicate<Biome>>>();
    private static final Map<String, Optional<Function<LivingEntity, Double>>> NAMED_ATTRIBUTES = new ConcurrentHashMap<String, Optional<Function<LivingEntity, Double>>>();
    private static final Map<String, Optional<Function<LivingEntity, MobEffectInstance>>> NAMED_EFFECTS = new ConcurrentHashMap<String, Optional<Function<LivingEntity, MobEffectInstance>>>();
    private static final Map<String, Optional<Function<ItemStack, Integer>>> NAMED_ENCHANTMENTS = new ConcurrentHashMap<String, Optional<Function<ItemStack, Integer>>>();

    public static String getItemKey(Item item) {
        return ITEM_NAMES.computeIfAbsent(item, it -> EnvironmentManager.getRegistryManager().getItemKey0((Item)it).toString());
    }

    public static String getBlockKey(Block block) {
        return BLOCK_NAMES.computeIfAbsent(block, it -> EnvironmentManager.getRegistryManager().getBlockKey0((Block)it).toString());
    }

    public static boolean hasItemTag(ItemStack itemStack, String tagName) {
        Optional tag = NAMED_ITEM_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getItemTag0));
        return tag.map(it -> it.test(itemStack)).orElse(false);
    }

    public static boolean hasBlockTag(BlockState blockState, String tagName) {
        Optional tag = NAMED_BLOCK_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getBlockTag0));
        return tag.map(it -> it.test(blockState)).orElse(false);
    }

    public static boolean hasBiomeTag(Biome biome, String tagName) {
        Optional tag = NAMED_BIOME_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getBiomeTag0));
        return tag.map(it -> it.test(biome)).orElse(false);
    }

    public static Biome getBiome(final Level level, final BlockPos blockPos) {
        return new Biome(){

            @Override
            public Level getLevel() {
                return level;
            }

            @Override
            public BlockPos getBlockPos() {
                return blockPos;
            }
        };
    }

    @Nullable
    public static MobEffectInstance getEffect(LivingEntity entity, String effectName) {
        Optional value = NAMED_EFFECTS.computeIfAbsent(effectName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getEffect0));
        return value.map(it -> (MobEffectInstance)it.apply(entity)).orElse(null);
    }

    public static double getAttribute(LivingEntity entity, String attributeName) {
        Optional value = NAMED_ATTRIBUTES.computeIfAbsent(attributeName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getAttribute0));
        return value.map(it -> (Double)it.apply(entity)).orElse(0.0);
    }

    public static Object getEnchantment(ItemStack itemStack, String enchantmentName) {
        Optional value = NAMED_ENCHANTMENTS.computeIfAbsent(enchantmentName, it -> AbstractRegistryManager.parse(it, AbstractRegistryManager::getEnchantment0));
        return value.map(it -> (Integer)it.apply(itemStack)).orElse(null);
    }

    private static <T> Optional<T> parse(String name, BiFunction<AbstractRegistryManager, ResourceLocation, T> factory) {
        ResourceLocation key = ResourceLocation.m_135820_((String)name);
        if (key != null) {
            return Optional.ofNullable(factory.apply(EnvironmentManager.getRegistryManager(), key));
        }
        return Optional.empty();
    }

    protected abstract ResourceLocation getItemKey0(Item var1);

    protected abstract ResourceLocation getBlockKey0(Block var1);

    protected abstract Predicate<ItemStack> getItemTag0(ResourceLocation var1);

    protected abstract Predicate<BlockState> getBlockTag0(ResourceLocation var1);

    protected abstract Predicate<Biome> getBiomeTag0(ResourceLocation var1);

    protected abstract Function<ItemStack, Integer> getEnchantment0(ResourceLocation var1);

    protected abstract Function<LivingEntity, MobEffectInstance> getEffect0(ResourceLocation var1);

    protected abstract Function<LivingEntity, Double> getAttribute0(ResourceLocation var1);

    public static interface Biome {
        public Level getLevel();

        public BlockPos getBlockPos();
    }
}

