/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.armature.Joint;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import org.jetbrains.annotations.Nullable;

public class Armature {
    private final IJoint[] joints;
    private final SkinPartType[] partTypes;
    private final Map<String, IJoint> namedJoints;
    private final Map<SkinPartType, IJoint> linkedJoints;
    private final IJoint wildcardJoint;
    private final IJointTransform[] localTransforms;
    private final IJointTransform[] globalTransforms;
    private final JointShape[] shapes;

    public Armature(Map<String, Joint> joints, Map<Joint, IJointTransform> transforms, Map<SkinPartType, Joint> linkedJoints, @Nullable Joint wildcardJoint, Map<Joint, JointShape> shapes) {
        this.joints = new IJoint[joints.size()];
        this.partTypes = new SkinPartType[joints.size()];
        this.localTransforms = new IJointTransform[joints.size()];
        this.globalTransforms = new IJointTransform[joints.size()];
        this.namedJoints = new LinkedHashMap<String, Joint>(joints);
        this.linkedJoints = new LinkedHashMap<SkinPartType, Joint>(linkedJoints);
        this.wildcardJoint = wildcardJoint;
        this.shapes = new JointShape[joints.size()];
        int id = 0;
        for (Joint joint : joints.values()) {
            this.joints[id] = joint;
            this.shapes[id] = shapes.get(joint);
            this.localTransforms[id] = transforms.getOrDefault(joint, IJointTransform.NONE);
            this.globalTransforms[id] = this.calcTransform(joint, transforms);
            joint.setId(id++);
        }
        for (Map.Entry entry : linkedJoints.entrySet()) {
            Joint joint = (Joint)entry.getValue();
            this.partTypes[joint.id()] = (SkinPartType)entry.getKey();
        }
    }

    @Nullable
    public IJoint jointByName(String name) {
        return this.namedJoints.get(name);
    }

    public IJoint jointById(int id) {
        return this.joints[id];
    }

    @Nullable
    public IJoint jointByType(SkinPartType partType) {
        return this.linkedJoints.getOrDefault(partType, this.wildcardJoint);
    }

    @Nullable
    public SkinPartType typeByJoint(IJoint joint) {
        return this.partTypes[joint.id()];
    }

    public IJointTransform localTransformById(int id) {
        return this.localTransforms[id];
    }

    public IJointTransform globalTransformById(int id) {
        return this.globalTransforms[id];
    }

    public JointShape shapeById(int id) {
        return this.shapes[id];
    }

    public Collection<IJoint> allJoints() {
        return this.namedJoints.values();
    }

    public int size() {
        return this.joints.length;
    }

    private IJointTransform calcTransform(Joint joint, Map<Joint, IJointTransform> transforms) {
        IJointTransform childTransform = transforms.getOrDefault(joint, IJointTransform.NONE);
        if (joint.parent() == null) {
            return childTransform;
        }
        IJointTransform parentTransform = this.calcTransform(joint.parent(), transforms);
        if (parentTransform == IJointTransform.NONE) {
            return childTransform;
        }
        if (childTransform == IJointTransform.NONE) {
            return parentTransform;
        }
        return poseStack -> {
            parentTransform.apply(poseStack);
            childTransform.apply(poseStack);
        };
    }
}

