/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform3f;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.client.texture.SmartTextureManager;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryFace;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryVertex;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeVertex;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedGeometryFace {
    private static final SkinPaintColor RAINBOW_TARGET = SkinPaintColor.of(-8421505, SkinPaintTypes.RAINBOW);
    private final IRenderType renderType;
    private final Collection<IRenderType> renderTypeVariants;
    private final float priority;
    private final ITransform3f transform;
    private final List<? extends SkinGeometryVertex> vertices;
    private final SkinGeometryVertex defaultVertex;
    private final SkinTexturePos defaultTexturePos;

    public BakedGeometryFace(SkinGeometryFace geometryFace) {
        this.priority = geometryFace.priority();
        this.transform = geometryFace.transform();
        this.renderType = this.resolveRenderType(geometryFace);
        this.renderTypeVariants = this.resolveRenderTypeVariants(geometryFace);
        this.vertices = this.triangulation(geometryFace.vertices(), geometryFace.type());
        this.defaultVertex = this.resolveDefaultVertex(this.vertices);
        this.defaultTexturePos = geometryFace.texturePos();
    }

    public void render(BakedSkinPart part, SkinPaintScheme scheme, int lightmap, int overlay, IPoseStack poseStack, IVertexConsumer builder) {
        if (this.defaultVertex == null) {
            return;
        }
        SkinGeometryVertex.Color vertexColor = this.defaultVertex.color();
        SkinPaintColor resolvedColor = this.resolveColor(vertexColor, scheme, part.colorInfo(), part.type(), 0);
        if (resolvedColor.paintType() == SkinPaintTypes.NONE) {
            return;
        }
        if (this.transform != OpenTransform3f.IDENTITY) {
            poseStack.pushPose();
            this.transform.apply(poseStack);
        }
        IPoseStack.Pose entry = poseStack.last();
        float u = this.resolveTextureOffset(vertexColor.paintType(), resolvedColor.paintType());
        float v = 0.0f;
        float n = this.defaultTexturePos.totalWidth();
        float m = this.defaultTexturePos.totalHeight();
        int r = resolvedColor.red();
        int g = resolvedColor.green();
        int b = resolvedColor.blue();
        int a = vertexColor.alpha();
        for (SkinGeometryVertex skinGeometryVertex : this.vertices) {
            OpenVector3f position = skinGeometryVertex.position();
            OpenVector3f normal = skinGeometryVertex.normal();
            OpenVector2f textureCoords = skinGeometryVertex.textureCoords();
            builder.vertex(entry, position.x(), position.y(), position.z()).color(r, g, b, a).uv((u + textureCoords.x()) / n, (v + textureCoords.y()) / m).overlayCoords(overlay).uv2(lightmap).normal(entry, normal.x(), normal.y(), normal.z()).endVertex();
        }
        if (this.transform != OpenTransform3f.IDENTITY) {
            poseStack.popPose();
        }
    }

    private SkinPaintColor dye(SkinPaintColor source, SkinPaintColor destination, SkinPaintColor average) {
        if (destination.paintType() == SkinPaintTypes.NONE) {
            return SkinPaintColor.CLEAR;
        }
        if (average == null) {
            return source;
        }
        int src = (source.red() + source.green() + source.blue()) / 3;
        int avg = (average.red() + average.green() + average.blue()) / 3;
        int r = OpenMath.clamp(destination.red() + src - avg, 0, 255);
        int g = OpenMath.clamp(destination.green() + src - avg, 0, 255);
        int b = OpenMath.clamp(destination.blue() + src - avg, 0, 255);
        return destination.withColor(r, g, b);
    }

    private SkinPaintColor resolveTextureColor(OpenResourceLocation texture, SkinPartType partType) {
        SkinGeometryVertex skinGeometryVertex;
        BakedEntityTexture bakedTexture = EntityTextureLoader.getInstance().getTextureModel(texture);
        if (bakedTexture != null && (skinGeometryVertex = this.defaultVertex) instanceof SkinCubeVertex) {
            SkinCubeVertex cubeVertex = (SkinCubeVertex)skinGeometryVertex;
            OpenRectangle3f shape = cubeVertex.boundingBox();
            OpenDirection direction = cubeVertex.direction();
            int x = (int)shape.x();
            int y = (int)shape.y();
            int z = (int)shape.z();
            return bakedTexture.getColor(x, y, z, direction, partType);
        }
        return null;
    }

    private float resolveTextureOffset(SkinPaintType from, SkinPaintType to) {
        SkinTexturePos toTexturePos;
        SkinTexturePos fromTexturePos = from.texturePos();
        if (fromTexturePos != (toTexturePos = to.texturePos())) {
            return toTexturePos.u() - fromTexturePos.u();
        }
        return 0.0f;
    }

    private SkinPaintColor resolveColor(SkinPaintColor paintColor, SkinPaintScheme scheme, ColorDescriptor descriptor, SkinPartType partType, int deep) {
        SkinPaintType paintType = paintColor.paintType();
        if (paintType == SkinPaintTypes.NONE) {
            return SkinPaintColor.CLEAR;
        }
        if (paintType == SkinPaintTypes.NORMAL) {
            return paintColor;
        }
        if (paintType == SkinPaintTypes.RAINBOW) {
            return this.dye(paintColor, RAINBOW_TARGET, descriptor.getAverageColor(paintType));
        }
        if (paintType == SkinPaintTypes.TEXTURE) {
            SkinPaintColor paintColor1 = this.resolveTextureColor(scheme.texture(), partType);
            if (paintColor1 != null) {
                return paintColor1;
            }
            return paintColor;
        }
        if (paintType.dyeType() != null && deep < 2) {
            SkinPaintColor paintColor1 = scheme.getResolvedColor(paintType);
            if (paintColor1 == null) {
                return paintColor;
            }
            paintColor = this.dye(paintColor, paintColor1, descriptor.getAverageColor(paintType));
            return this.resolveColor(paintColor, scheme, descriptor, partType, deep + 1);
        }
        return paintColor;
    }

    private List<? extends SkinGeometryVertex> triangulation(Iterable<? extends SkinGeometryVertex> verticesIn, SkinGeometryType geometryType) {
        ArrayList<? extends SkinGeometryVertex> vertices = Collections.newList(verticesIn);
        if (geometryType != SkinGeometryTypes.MESH && geometryType != SkinGeometryTypes.MESH_CULL) {
            return vertices;
        }
        return switch (vertices.size()) {
            case 3 -> vertices;
            case 4 -> {
                ArrayList<SkinGeometryVertex> newVertices = new ArrayList<SkinGeometryVertex>(6);
                newVertices.add(vertices.get(0));
                newVertices.add(vertices.get(1));
                newVertices.add(vertices.get(2));
                newVertices.add(vertices.get(2));
                newVertices.add(vertices.get(3));
                newVertices.add(vertices.get(0));
                yield newVertices;
            }
            default -> throw new RuntimeException("Can't convert polygon (" + vertices.size() + ") to triangle!");
        };
    }

    private SkinGeometryVertex resolveDefaultVertex(List<? extends SkinGeometryVertex> vertices) {
        if (!vertices.isEmpty()) {
            return vertices.get(0);
        }
        return null;
    }

    private IRenderType resolveRenderType(SkinGeometryFace face) {
        SkinTexturePos texturePos = face.texturePos();
        if (texturePos != null && texturePos.provider() != null) {
            return SmartTextureManager.getInstance().register(texturePos.provider(), face.type());
        }
        return SkinRenderType.by(face.type());
    }

    private Collection<IRenderType> resolveRenderTypeVariants(SkinGeometryFace face) {
        SkinTexturePos texture = face.texturePos();
        if (texture == null || texture.provider() == null) {
            return null;
        }
        SkinTextureData parent = texture.provider();
        ArrayList<IRenderType> renderTypes = new ArrayList<IRenderType>();
        for (SkinTextureData variant : parent.variants()) {
            SkinTextureProperties properties = variant.properties();
            if (properties.isNormal() || properties.isSpecular()) continue;
            renderTypes.add(SmartTextureManager.getInstance().register(variant, face.type()));
        }
        return renderTypes;
    }

    public float priority() {
        return this.priority;
    }

    public ITransform3f transform() {
        return this.transform;
    }

    public List<? extends SkinGeometryVertex> vertices() {
        return this.vertices;
    }

    public IRenderType renderType() {
        return this.renderType;
    }

    public Collection<IRenderType> renderTypeVariants() {
        return this.renderTypeVariants;
    }

    public SkinPaintColor defaultColor() {
        if (this.defaultVertex != null) {
            return this.defaultVertex.color();
        }
        return null;
    }
}

