/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.apple.library.uikit.UIColor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.model.SkinItemModel;
import moe.plushie.armourers_workshop.core.client.model.SkinItemModelManager;
import moe.plushie.armourers_workshop.core.client.model.SkinItemOverride;
import moe.plushie.armourers_workshop.core.client.model.SkinItemTransform;
import moe.plushie.armourers_workshop.core.client.other.SkinItemProperties;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class BakedItemTransform {
    protected final SkinItemModel itemModel;
    protected final OpenTransform3f offsetTransform;

    protected BakedItemTransform(SkinItemModel itemModel, OpenTransform3f offsetTransform) {
        this.itemModel = itemModel;
        this.offsetTransform = offsetTransform;
    }

    public static BakedItemTransform create(List<BakedSkinPart> skinParts, OpenItemTransforms itemTransforms, SkinType skinType) {
        if (itemTransforms == null) {
            SkinItemModel itemModel = SkinItemModelManager.getInstance().getModel(skinType);
            return new Builtin(itemModel, null);
        }
        return BakedItemTransform.create(skinParts, itemTransforms);
    }

    private static BakedItemTransform create(List<BakedSkinPart> skinParts, OpenItemTransforms itemTransforms) {
        EnumMap<OpenItemDisplayContext, SkinItemTransform> transforms = new EnumMap<OpenItemDisplayContext, SkinItemTransform>(OpenItemDisplayContext.class);
        for (OpenItemDisplayContext value : OpenItemDisplayContext.values()) {
            OpenTransform3f itemTransform = itemTransforms.get(value);
            if (itemTransform == null) continue;
            transforms.put(value, SkinItemTransform.create(itemTransform));
        }
        ArrayList<SkinItemOverride> overrides = new ArrayList<SkinItemOverride>();
        for (BakedSkinPart bakedSkinPart : skinParts) {
        }
        SkinItemModel itemModel = new SkinItemModel(null, overrides, transforms);
        return new Custom(itemModel, itemTransforms.offset());
    }

    public void apply(IPoseStack poseStack, @Nullable Entity entity, BakedSkin skin, SkinRenderContext context) {
        OpenVector3f displayBox;
        SkinItemSource itemSource = context.itemSource();
        SkinItemModel itemModel = this.resolve(entity, itemSource.item(), itemSource.properties(), itemSource.displayContext());
        if (itemModel == null) {
            return;
        }
        if (ModDebugger.targetBounds) {
            AbstractBufferSource tesselator = AbstractBufferSource.tesselator();
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, poseStack, tesselator);
            ShapeTesselator.stroke(-8.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, UIColor.CYAN, poseStack, (IBufferSource)tesselator);
            tesselator.endBatch();
        }
        OpenItemDisplayContext displayContext = itemSource.displayContext();
        SkinItemTransform itemTransform = itemModel.getTransform(displayContext);
        this.applyItemTransform(itemTransform, displayContext, poseStack);
        if (ModDebugger.targetBounds) {
            AbstractBufferSource tesselator = AbstractBufferSource.tesselator();
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, poseStack, tesselator);
            ShapeTesselator.stroke(-8.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, UIColor.YELLOW, poseStack, (IBufferSource)tesselator);
            tesselator.endBatch();
        }
        if ((displayBox = context.displayBox()) != null) {
            this.applyScaleInBox(itemTransform, displayContext, skin, displayBox, poseStack);
        }
    }

    protected void applyItemTransform(SkinItemTransform itemTransform, OpenItemDisplayContext displayContext, IPoseStack poseStack) {
        itemTransform.apply(displayContext.isLeftHand(), poseStack);
        if (this.offsetTransform != null) {
            this.offsetTransform.apply(poseStack);
        }
    }

    protected void applyScaleInBox(SkinItemTransform itemTransform, OpenItemDisplayContext displayContext, BakedSkin skin, OpenVector3f displayBox, IPoseStack poseStack) {
        OpenRectangle3f renderBounds = skin.getRenderBounds(itemTransform, displayContext);
        float dx = displayBox.x() * 16.0f;
        float dy = displayBox.y() * 16.0f;
        float dz = displayBox.z() * 16.0f;
        float scale = Math.min(Math.min(dx / renderBounds.width(), dy / renderBounds.height()), dz / renderBounds.depth());
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-renderBounds.midX(), -renderBounds.midY(), -renderBounds.midZ());
    }

    protected SkinItemModel resolve(Entity entity, ItemStack itemStack, SkinItemProperties itemProperties, OpenItemDisplayContext displayContext) {
        if (entity == null) {
            return null;
        }
        if (itemProperties != null && !itemProperties.isAllowOverrides()) {
            return this.itemModel;
        }
        return this.itemModel.resolve(itemStack, entity, entity.m_9236_(), 0, displayContext);
    }

    private static class Builtin
    extends BakedItemTransform {
        protected Builtin(SkinItemModel itemModel, OpenTransform3f offsetTransform) {
            super(itemModel, offsetTransform);
        }
    }

    private static class Custom
    extends BakedItemTransform {
        protected Custom(SkinItemModel itemModel, OpenTransform3f afterTransform) {
            super(itemModel, afterTransform);
        }

        @Override
        protected void applyItemTransform(SkinItemTransform itemTransform, OpenItemDisplayContext displayContext, IPoseStack poseStack) {
            if (displayContext != OpenItemDisplayContext.NONE) {
                super.applyItemTransform(itemTransform, displayContext, poseStack);
            }
        }

        @Override
        protected void applyScaleInBox(SkinItemTransform itemTransform, OpenItemDisplayContext displayContext, BakedSkin skin, OpenVector3f displayBox, IPoseStack poseStack) {
            if (displayContext == OpenItemDisplayContext.NONE) {
                super.applyScaleInBox(itemTransform, displayContext, skin, displayBox, poseStack);
            }
        }
    }
}

