/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.notification;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.core.client.gui.ServerAlertWindow;
import moe.plushie.armourers_workshop.core.client.gui.ServerToastWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.BaseDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.ContainerMenuToast;
import moe.plushie.armourers_workshop.core.client.gui.widget.ToastWindow;
import moe.plushie.armourers_workshop.core.network.ExecuteAlertPacket;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class UserNotificationCenter {
    public static void showAlertFromServer(ExecuteAlertPacket alertPacket) {
        RenderSystem.m_69879_(() -> {
            if ((alertPacket.type() & Integer.MIN_VALUE) != 0) {
                ServerToastWindow window = new ServerToastWindow(alertPacket);
                window.showInScreen();
            } else {
                ServerAlertWindow window = new ServerAlertWindow(alertPacket);
                window.showInScreen();
            }
        });
    }

    public static void showAlert(NSString title, NSString message, UIColor messageColor, UIView view) {
        Impl alert = new Impl();
        alert.setTitle(title);
        alert.setMessage(message);
        if (messageColor != null) {
            alert.setMessageColor(messageColor);
        }
        alert.showInView(view, () -> {});
    }

    public static void showToast(NSString message, @Nullable UIColor messageColor, NSString title, Object icon) {
        ToastWindow window = new ToastWindow(new CGRect(0.0f, 0.0f, 160.0f, 32.0f));
        window.setTitle(title);
        window.setTitleColor(UIColor.of(-30465));
        window.setMessage(message);
        window.setMessageColor(messageColor);
        window.setIcon(icon);
        Minecraft.m_91087_().m_91300_().m_94922_(new ContainerMenuToast<ToastWindow>(window));
    }

    public static void showToast(NSString message, NSString title, Object icon) {
        UserNotificationCenter.showToast(message, UIColor.WHITE, title, icon);
    }

    public static void showToast(Exception exception, NSString title, Object icon) {
        NSString message;
        if (exception instanceof TranslatableException) {
            TranslatableException exception1 = (TranslatableException)exception;
            message = new NSString(exception1.getComponent());
        } else {
            message = new NSString(exception.getMessage());
        }
        exception.printStackTrace();
        UserNotificationCenter.showToast(message, UIColor.RED, title, icon);
    }

    private static class Impl
    extends BaseDialog {
        protected final UILabel messageLabel = new UILabel(new CGRect(0.0f, 8.0f, 240.0f, 20.0f));
        protected final UIButton confirmButton = this.buildButton(0, 0, 100, 20, Impl::confirmAction);
        private NSString confirmText;

        public Impl() {
            this.messageLabel.setNumberOfLines(0);
            this.addSubview(this.messageLabel);
            this.setConfirmText(NSString.localizedTableString("commands", "notify.confirm", new Object[0]));
            this.setup();
        }

        private void setup() {
            CGRect rect = this.bounds();
            float w = 100.0f;
            float sp = (rect.width - w) / 2.0f;
            float bottom = rect.height - 30.0f;
            this.messageLabel.setFrame(new CGRect(10.0f, 30.0f, rect.width - 20.0f, 20.0f));
            this.messageLabel.setAutoresizingMask(2);
            this.confirmButton.setFrame(new CGRect(sp, bottom, w, 20.0f));
            this.confirmButton.setAutoresizingMask(9);
        }

        protected UIButton buildButton(int x, int y, int width, int height, BiConsumer<Impl, UIControl> event) {
            UIButton button = new UIButton(new CGRect(x, y, width, height));
            button.setTitleColor(UIColor.WHITE, 7);
            button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
            button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, event);
            this.addSubview(button);
            return button;
        }

        public NSString message() {
            return this.messageLabel.text();
        }

        public void setMessage(NSString message) {
            this.messageLabel.setText(message);
        }

        public UIColor messageColor() {
            return this.messageLabel.textColor();
        }

        public void setMessageColor(UIColor color) {
            this.messageLabel.setTextColor(color);
        }

        public NSString confirmText() {
            return this.confirmText;
        }

        public void setConfirmText(NSString text) {
            this.confirmText = text;
            this.confirmButton.setTitle(text, 0);
        }

        public void confirmAction(UIControl sender) {
            this.dismiss();
        }
    }
}

