/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIWindow;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Constructor;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;

public class ToastWindow
extends UIWindow {
    protected final UILabel titleLabel = new UILabel(CGRect.ZERO);
    protected final UILabel messageLabel = new UILabel(CGRect.ZERO);
    private double duration = 5000.0;
    private Object icon;
    private final CGRect iconRect = new CGRect(8.0f, 8.0f, 18.0f, 18.0f);

    public ToastWindow(CGRect frame) {
        super(frame);
        this.setContents(UIImage.of(this.defaultTexture()).resizable(160.0f, 32.0f).build());
        this.titleLabel.setFrame(new CGRect(30.0f, 7.0f, frame.width - 30.0f - 5.0f, 9.0f));
        this.titleLabel.setAutoresizingMask(34);
        this.titleLabel.setTextColor(UIColor.of(-256));
        this.addSubview(this.titleLabel);
        this.messageLabel.setFrame(new CGRect(30.0f, 18.0f, frame.width - 30.0f - 5.0f, 9.0f));
        this.messageLabel.setAutoresizingMask(34);
        this.messageLabel.setTextColor(UIColor.WHITE);
        this.addSubview(this.messageLabel);
        this.updateIconRect();
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        Object object = this.icon();
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            context.drawItem(itemStack, 8, 8);
            return;
        }
        object = this.icon();
        if (object instanceof CustomTexture) {
            CustomTexture texture = (CustomTexture)object;
            context.drawImage(texture.image, this.iconRect.offset(texture.origin));
            return;
        }
    }

    public NSString title() {
        return this.titleLabel.text();
    }

    public void setTitle(NSString title) {
        this.titleLabel.setText(title);
    }

    public NSString message() {
        return this.messageLabel.text();
    }

    public void setMessage(NSString title) {
        this.messageLabel.setText(title);
    }

    public UIColor titleColor() {
        return this.titleLabel.textColor();
    }

    public void setTitleColor(UIColor color) {
        this.titleLabel.setTextColor(color);
    }

    public UIColor messageColor() {
        return this.messageLabel.textColor();
    }

    public void setMessageColor(UIColor color) {
        this.messageLabel.setTextColor(color);
    }

    public void setIcon(Object icon) {
        this.icon = icon;
        if (!(icon instanceof CompoundTag)) {
            this.updateIconRect();
            return;
        }
        CompoundTag tag = (CompoundTag)icon;
        OptionalAPI.getOptionalString(tag, "Skin").ifPresent(skinId -> {
            SkinDescriptor descriptor = new SkinDescriptor((String)skinId);
            this.icon = descriptor.asItemStack();
        });
        OptionalAPI.getOptionalString(tag, "Image").ifPresent(imageId -> {
            this.icon = new CustomTexture((String)imageId, tag);
        });
        ClientLevel level = EnvironmentManager.getClient().f_91073_;
        if (tag.m_128441_("id") && level != null) {
            this.icon = Constructor.parse(ItemStack.class, level.m_5962_(), tag).orElse(ItemStack.f_41583_);
        }
        this.updateIconRect();
    }

    public Object icon() {
        return this.icon;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double duration() {
        return this.duration;
    }

    private IResourceLocation defaultTexture() {
        return ModTextures.TOASTS;
    }

    private void updateIconRect() {
        float x1 = 0.0f;
        float x2 = this.titleLabel.frame().maxX();
        float x3 = 0.0f;
        float x4 = this.messageLabel.frame().maxX();
        if (this.icon != null) {
            x1 = 30.0f;
            x3 = 30.0f;
        } else {
            x1 = 8.0f;
            x3 = 8.0f;
        }
        CGRect nf1 = new CGRect(this.titleLabel.frame());
        nf1.x = x1;
        nf1.width = x2 - x1;
        this.titleLabel.setFrame(nf1);
        CGRect nf2 = new CGRect(this.messageLabel.frame());
        nf2.x = x3;
        nf2.width = x4 - x3;
        this.messageLabel.setFrame(nf2);
    }

    public static class CustomTexture {
        public final CGPoint origin;
        public final UIImage image;

        public CustomTexture(String id, CompoundTag tag) {
            int[] offset = new int[]{0, 0};
            UIImage.Builder builder = UIImage.of(OpenResourceLocation.parse(id));
            this.apply(tag, "UV", 2, it -> builder.uv(it[0], it[1]));
            this.apply(tag, "Fixed", 2, it -> builder.fixed(it[0], it[1]));
            this.apply(tag, "Resizable", 2, it -> builder.resizable(it[0], it[1]));
            this.apply(tag, "Resize", 4, it -> builder.resize(it[0], it[1], it[2], it[3]));
            this.apply(tag, "Limit", 2, it -> builder.limit(it[0], it[1]));
            this.apply(tag, "Clip", 4, it -> builder.clip(it[0], it[1], it[2], it[3]));
            this.apply(tag, "Origin", 2, it -> {
                offset[0] = it[0];
                offset[1] = it[1];
            });
            this.image = builder.build();
            this.origin = new CGPoint(offset[0], offset[1]);
        }

        private void apply(CompoundTag tag, String key, int limit, Consumer<int[]> consumer) {
            ListTag list = OptionalAPI.getOptionalList(tag, key, 3).orElse(null);
            if (list == null || list.size() < limit) {
                return;
            }
            int[] data = new int[list.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalInt(list, i).orElse(0);
            }
            consumer.accept(data);
        }
    }
}

