/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;

public class VerticalStackView
extends UIView {
    protected float spacing = 2.0f;
    protected final ArrayList<UIView> _arrangedSubviews = new ArrayList();

    public VerticalStackView(CGRect frame) {
        super(frame);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        this._calcLayout(this.bounds().size(), true);
    }

    @Override
    public CGSize sizeThatFits(CGSize size) {
        return this._calcLayout(size, false);
    }

    @Override
    public void sizeToFit() {
        this._setSize(this._calcLayout(this.bounds().size(), true));
    }

    public void addArrangedSubview(UIView view) {
        this.addSubview(view);
        this._arrangedSubviews.add(view);
        this.setNeedsLayout();
    }

    public void removeArrangedSubview(UIView view) {
        view.removeFromSuperview();
        this._arrangedSubviews.remove(view);
        this.setNeedsLayout();
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
    }

    public float spacing() {
        return this.spacing;
    }

    private CGSize _calcLayout(CGSize size, boolean apply) {
        float top = 0.0f;
        float width = size.width;
        for (UIView subview : this._arrangedSubviews) {
            CGRect rect = subview.frame().copy();
            if (apply) {
                rect.setY(top);
                rect.setWidth(width);
                subview.setFrame(rect);
            }
            top += rect.height + this.spacing;
        }
        return new CGSize(width, Math.max(top - this.spacing, 0.0f));
    }
}

