/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.client.model.SkinItemOverride;
import moe.plushie.armourers_workshop.core.client.model.SkinItemProperty;
import moe.plushie.armourers_workshop.core.client.model.SkinItemTransform;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SkinItemModel {
    private final IResourceLocation name;
    private final Map<OpenItemDisplayContext, SkinItemTransform> transforms;
    private final SkinItemProperty[] properties;
    private final List<Matcher> matchers = new ArrayList<Matcher>();

    public SkinItemModel(IResourceLocation name, List<SkinItemOverride> overrides, Map<OpenItemDisplayContext, SkinItemTransform> transforms) {
        this.name = name;
        this.transforms = transforms;
        ArrayList<SkinItemProperty> indexedProperties = new ArrayList<SkinItemProperty>();
        for (SkinItemOverride override : overrides) {
            ArrayList<Predicate<float[]>> childTester = new ArrayList<Predicate<float[]>>();
            SkinItemProperty[] childProperties = override.properties();
            float[] childValues = override.values();
            for (int i = 0; i < childProperties.length; ++i) {
                SkinItemProperty childProperty = childProperties[i];
                float childValue = childValues[i];
                int idx = indexedProperties.indexOf(childProperty);
                if (idx == -1) {
                    idx = indexedProperties.size();
                    indexedProperties.add(childProperty);
                }
                int index = idx;
                childTester.add(result -> result[index] >= childValue);
            }
            this.matchers.add(new Matcher(override, childTester));
        }
        this.properties = indexedProperties.toArray(new SkinItemProperty[0]);
    }

    public SkinItemModel resolve(ItemStack itemStack, @Nullable Entity entity, @Nullable Level level, int flags, OpenItemDisplayContext displayContext) {
        int length = this.properties.length;
        if (length == 0) {
            return this;
        }
        float[] results = new float[length];
        for (int i = 0; i < length; ++i) {
            results[i] = this.properties[i].apply(itemStack, entity, level, flags, displayContext);
        }
        for (Matcher matcher : this.matchers) {
            if (!matcher.test(results)) continue;
            SkinItemModel model = matcher.override.model();
            if (model != null) {
                return model;
            }
            return this;
        }
        return this;
    }

    public SkinItemTransform getTransform(OpenItemDisplayContext transformType) {
        return this.transforms.getOrDefault((Object)transformType, SkinItemTransform.NO_TRANSFORM);
    }

    public IResourceLocation name() {
        return this.name;
    }

    private static class Matcher {
        private final List<Predicate<float[]>> testers;
        private final SkinItemOverride override;

        public Matcher(SkinItemOverride override, List<Predicate<float[]>> tester) {
            this.testers = tester;
            this.override = override;
        }

        public boolean test(float[] results) {
            for (Predicate<float[]> tester : this.testers) {
                if (tester.test(results)) continue;
                return false;
            }
            return true;
        }
    }
}

