/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenNativeImage;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class SkinDynamicTexture
extends DynamicTexture {
    private final TextureManager textureManager = EnvironmentManager.getClient().m_91097_();
    private SkinPaintData paintData;
    private OpenNativeImage downloadedImage;
    private OpenResourceLocation refer;
    private AbstractTexture referTexture;
    private boolean needsUpdate = true;

    public SkinDynamicTexture() {
        super(64, 64, true);
    }

    public OpenResourceLocation refer() {
        return this.refer;
    }

    public void setRefer(OpenResourceLocation refer) {
        if (!Objects.equals(this.refer, refer)) {
            this.refer = refer;
            this.referTexture = Objects.flatMap(refer, it -> this.textureManager.m_118506_(it.toLocation()));
            this.downloadedImage = null;
            this.setNeedsUpdate();
        }
    }

    public SkinPaintData paintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData != paintData) {
            this.paintData = paintData;
            this.setNeedsUpdate();
        }
    }

    public void m_117985_() {
        OpenNativeImage downloadedImage = this.downloadedImage();
        OpenNativeImage mergedImage = OpenNativeImage.of(this.m_117991_());
        if (mergedImage == null || downloadedImage == null) {
            return;
        }
        mergedImage.copyFrom(downloadedImage);
        if (this.paintData != null) {
            this.applyPaintColor(mergedImage);
        }
        super.m_117985_();
    }

    private void setNeedsUpdate() {
        this.needsUpdate = true;
        RenderSystem.m_69879_(() -> {
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.m_117985_();
            }
        });
    }

    private void applyPaintColor(OpenNativeImage mergedImage) {
        for (int iy = 0; iy < this.paintData.height(); ++iy) {
            for (int ix = 0; ix < this.paintData.width(); ++ix) {
                int color = this.paintData.getColor(ix, iy);
                if (!SkinPaintColor.isOpaque(color)) continue;
                mergedImage.setPixel(ix, iy, color);
            }
        }
    }

    private OpenNativeImage downloadedImage() {
        if (this.downloadedImage != null) {
            return this.downloadedImage;
        }
        if (this.referTexture != null) {
            GL11.glBindTexture((int)3553, (int)this.referTexture.m_117963_());
            this.downloadedImage = OpenNativeImage.of(0, 64, 64);
        }
        return this.downloadedImage;
    }
}

