/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import moe.plushie.armourers_workshop.core.client.other.VertexArrayObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexObject;
import moe.plushie.armourers_workshop.core.client.shader.ShaderContext;
import moe.plushie.armourers_workshop.core.client.shader.ShaderRenderState;
import moe.plushie.armourers_workshop.core.client.shader.ShaderUniforms;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public abstract class Shader {
    protected final Int2ObjectOpenHashMap<OpenMatrix4f> overlayMatrices = new Int2ObjectOpenHashMap();
    protected final Int2ObjectOpenHashMap<OpenMatrix4f> lightmapMatrices = new Int2ObjectOpenHashMap();
    protected final Int2ObjectOpenHashMap<OpenVector4f> outlineColors = new Int2ObjectOpenHashMap();
    protected final ShaderContext context = ShaderContext.getInstance();
    protected final ShaderRenderState renderState = new ShaderRenderState();

    public void begin() {
        this.context.saveState();
        this.context.setModelViewMatrix(OpenMatrix4f.identity());
        this.context.setMatrixFlags(1);
        this.context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        ShaderUniforms.begin();
        if (ModDebugger.wireframeRender) {
            this.context.polygonMode(1032, 6913);
        }
    }

    public void end() {
        if (ModDebugger.wireframeRender) {
            this.context.polygonMode(1032, 6914);
        }
        ShaderUniforms.end();
        this.context.setMatrixFlags(0);
        this.context.restoreState();
    }

    protected void prepare(ShaderVertexGroup group) {
        this.renderState.save();
        this.context.setTextureMatrix(group.getTextureMatrix(TickUtils.animationTicks()));
        this.context.enablePolygonOffset();
    }

    protected void clean(ShaderVertexGroup group) {
        this.context.disablePolygonOffset();
        VertexArrayObject.unbind();
        this.renderState.load();
    }

    public void apply(ShaderVertexGroup group, Runnable action) {
        this.prepare(group);
        action.run();
        this.clean(group);
    }

    public void render(ShaderVertexObject object) {
        OpenPoseStack.Pose entry = object.poseStack().last();
        this.context.setObjectViewMatrix(entry.pose());
        this.context.setObjectNormalMatrix(entry.normal());
        this.context.setOverlayTextureMatrix(this.getOverlayTextureMatrix(object));
        this.context.setLightmapTextureMatrix(this.getLightmapTextureMatrix(object));
        this.context.setColorModulator(this.getColorColorModulator(object));
        this.context.setMatrixFlags(entry.properties() | 1);
        this.context.polygonOffset(0.0f, -50.0f + object.polygonOffset() * -1.0f);
        ShaderUniforms.getInstance().apply(this.getLastProgramId());
        this.drawElements(object, object.arrayObject(), object.indexObject(), object.total());
    }

    protected void drawElements(ShaderVertexObject vertexObject, VertexArrayObject arrayObject, VertexIndexObject indexObject, int count) {
        arrayObject.bind();
        if (indexObject != null) {
            GL15.glDrawElements((int)4, (int)indexObject.stride(count), (int)indexObject.type(), (long)0L);
        } else {
            GL15.glDrawArrays((int)4, (int)0, (int)count);
        }
    }

    protected int getLastProgramId() {
        return this.renderState.lastProgramId();
    }

    protected OpenMatrix4f getOverlayTextureMatrix(ShaderVertexObject object) {
        if (object.overlay() == OverlayTexture.f_118083_) {
            return OpenMatrix4f.identity();
        }
        return (OpenMatrix4f)this.overlayMatrices.computeIfAbsent(object.overlay(), overlay -> {
            int u = overlay & 0xFFFF;
            int v = overlay >> 16 & 0xFFFF;
            OpenMatrix4f newValue = OpenMatrix4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
            newValue.setTranslation(u, v, 0.0f);
            return newValue;
        });
    }

    protected OpenMatrix4f getLightmapTextureMatrix(ShaderVertexObject object) {
        if (object.isEmissive()) {
            return OpenMatrix4f.identity();
        }
        return (OpenMatrix4f)this.lightmapMatrices.computeIfAbsent(object.lightmap(), lightmap -> {
            int u = lightmap & 0xFFFF;
            int v = lightmap >> 16 & 0xFFFF;
            OpenMatrix4f newValue = OpenMatrix4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
            newValue.setTranslation(u, v, 0.0f);
            return newValue;
        });
    }

    protected OpenVector4f getColorColorModulator(ShaderVertexObject object) {
        if (object.isOutline()) {
            return this.getOutlineColor(object);
        }
        return OpenVector4f.ONE;
    }

    protected OpenVector4f getOutlineColor(ShaderVertexObject object) {
        return (OpenVector4f)this.outlineColors.computeIfAbsent(object.outlineColor() | 0xFF000000, color -> {
            float red = (float)ColorUtils.getRed(color) / 255.0f;
            float green = (float)ColorUtils.getGreen(color) / 255.0f;
            float blue = (float)ColorUtils.getBlue(color) / 255.0f;
            return new OpenVector4f(red, green, blue, 1.0f);
        });
    }
}

