/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public enum OptionalDirection {
    NONE,
    DOWN(OpenDirection.DOWN),
    UP(OpenDirection.UP),
    NORTH(OpenDirection.NORTH),
    SOUTH(OpenDirection.SOUTH),
    WEST(OpenDirection.WEST),
    EAST(OpenDirection.EAST);

    final OpenDirection direction;
    final String name;

    private OptionalDirection() {
        this.name = "none";
        this.direction = null;
    }

    private OptionalDirection(OpenDirection direction) {
        this.name = direction.serializedName();
        this.direction = direction;
    }

    public static OptionalDirection of(OpenDirection direction) {
        for (OptionalDirection dir : OptionalDirection.values()) {
            if (!direction.equals(dir.direction())) continue;
            return dir;
        }
        return NONE;
    }

    public static OptionalDirection of(Direction direction) {
        return OptionalDirection.of(AbstractDirection.wrap(direction));
    }

    @Nullable
    public OpenDirection direction() {
        return this.direction;
    }

    public String toString() {
        return this.name;
    }
}

