/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.action;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.data.action.EntityAction;
import moe.plushie.armourers_workshop.core.data.action.EntityActionTarget;

public class EntityActions {
    private static final Map<String, EntityActionTarget> NAMED_ACTIONS = new HashMap<String, EntityActionTarget>();
    public static final EntityActionTarget IDLE = EntityActions.normal().action(EntityAction.IDLE).priority(100.0f).build("idle");
    public static final EntityActionTarget WALK = EntityActions.normal().action(EntityAction.WALK).priority(220.0f).build("walk");
    public static final EntityActionTarget RUN = EntityActions.normal().action(EntityAction.WALK).action(EntityAction.RUNNING).priority(240.0f).build("run");
    public static final EntityActionTarget JUMP = EntityActions.normal().action(EntityAction.JUMP).transition(0.0).priority(280.0f).build("jump");
    public static final EntityActionTarget SNEAK = EntityActions.normal().action(EntityAction.SNEAK).priority(200.0f).build("sneak");
    public static final EntityActionTarget SNEAK_IDLE = EntityActions.normal().action(EntityAction.SNEAK).priority(220.0f).build("sneak_idle");
    public static final EntityActionTarget SNEAK_WALK = EntityActions.normal().action(EntityAction.SNEAK).action(EntityAction.WALK).priority(240.0f).build("sneak_walk");
    public static final EntityActionTarget SWIM = EntityActions.normal().action(EntityAction.SWIMMING).priority(300.0f).build("swim");
    public static final EntityActionTarget SWIM_IDLE = EntityActions.normal().action(EntityAction.SWIMMING).priority(320.0f).build("swim_idle");
    public static final EntityActionTarget SWIM_WALK = EntityActions.normal().action(EntityAction.SWIMMING).action(EntityAction.SWIMMING_WALK).priority(340.0f).build("swim_walk");
    public static final EntityActionTarget SWIM_SPRINT = EntityActions.normal().action(EntityAction.SWIMMING).action(EntityAction.SWIMMING_BOOST).priority(380.0f).build("swim_sprint");
    public static final EntityActionTarget FLY = EntityActions.normal().action(EntityAction.FLYING).priority(400.0f).build("fly");
    public static final EntityActionTarget FLY_IDLE = EntityActions.normal().action(EntityAction.FLYING).priority(420.0f).build("fly_idle");
    public static final EntityActionTarget FLY_WALK = EntityActions.normal().action(EntityAction.FLYING).action(EntityAction.FLYING_WALK).priority(440.0f).build("fly_walk");
    public static final EntityActionTarget FLY_SPRINT = EntityActions.normal().action(EntityAction.FLYING).action(EntityAction.FLYING_BOOST).priority(480.0f).build("fly_sprint");
    public static final EntityActionTarget FALL_FLY = EntityActions.normal().action(EntityAction.FLYING).action(EntityAction.FLYING_FALL).priority(401.0f).build("fall_fly");
    public static final EntityActionTarget FALL_FLY_IDLE = EntityActions.normal().action(EntityAction.FLYING).action(EntityAction.FLYING_FALL).priority(421.0f).build("fall_fly_idle");
    public static final EntityActionTarget FALL_FLY_WALK = EntityActions.normal().action(EntityAction.FLYING).action(EntityAction.FLYING_FALL).action(EntityAction.FLYING_WALK).priority(441.0f).build("fall_fly_walk");
    public static final EntityActionTarget FALL_FLY_SPRINT = EntityActions.normal().action(EntityAction.FLYING).action(EntityAction.FLYING_FALL).action(EntityAction.FLYING_BOOST).priority(481.0f).build("fall_fly_sprint");
    public static final EntityActionTarget RIDE = EntityActions.normal().action(EntityAction.RIDING).priority(500.0f).build("ride");
    public static final EntityActionTarget RIDE_IDLE = EntityActions.normal().action(EntityAction.RIDING).priority(520.0f).build("ride_idle");
    public static final EntityActionTarget RIDE_WALK = EntityActions.normal().action(EntityAction.RIDING).action(EntityAction.RIDING_WALK).priority(540.0f).build("ride_walk");
    public static final EntityActionTarget RIDE_SPRINT = EntityActions.normal().action(EntityAction.RIDING).action(EntityAction.FLYING_BOOST).priority(580.0f).build("ride_sprint");
    public static final EntityActionTarget BOAT = EntityActions.normal().action(EntityAction.RIDING).action(EntityAction.RIDING_BOAT).priority(501.0f).build("boat");
    public static final EntityActionTarget BOAT_IDLE = EntityActions.normal().action(EntityAction.RIDING).action(EntityAction.RIDING_BOAT).priority(521.0f).build("boat_idle");
    public static final EntityActionTarget BOAT_WALK = EntityActions.normal().action(EntityAction.RIDING).action(EntityAction.RIDING_BOAT).action(EntityAction.RIDING_WALK).priority(541.0f).build("boat_walk");
    public static final EntityActionTarget BOAT_SPRINT = EntityActions.normal().action(EntityAction.RIDING).action(EntityAction.RIDING_BOAT).action(EntityAction.FLYING_BOOST).priority(581.0f).build("boat_sprint");
    public static final EntityActionTarget CRAWL = EntityActions.normal().action(EntityAction.CRAWLING).priority(800.0f).build("crawl");
    public static final EntityActionTarget CRAWL_IDLE = EntityActions.normal().action(EntityAction.CRAWLING).priority(820.0f).build("crawl_idle");
    public static final EntityActionTarget CRAWL_WALK = EntityActions.normal().action(EntityAction.CRAWLING).action(EntityAction.CRAWLING_WALK).priority(840.0f).build("crawl_walk");
    public static final EntityActionTarget CLIMB = EntityActions.normal().action(EntityAction.CLIMBING).priority(800.0f).build("climb");
    public static final EntityActionTarget CLIMB_IDLE = EntityActions.normal().action(EntityAction.CLIMBING).priority(820.0f).build("climb_idle");
    public static final EntityActionTarget CLIMB_WALK = EntityActions.normal().action(EntityAction.CLIMBING).action(EntityAction.CLIMBING_WALK).priority(847.0f).build("climb_walk");
    public static final EntityActionTarget CLIMB_WALK_UP = EntityActions.normal().action(EntityAction.CLIMBING).action(EntityAction.CLIMBING_UP).priority(848.0f).build("climb_walk_up");
    public static final EntityActionTarget CLIMB_WALK_DOWN = EntityActions.normal().action(EntityAction.CLIMBING).action(EntityAction.CLIMBING_DOWN).priority(849.0f).build("climb_walk_down");
    public static final EntityActionTarget CLIMB_HOLD = EntityActions.normal().action(EntityAction.CLIMBING).action(EntityAction.CLIMBING_HOLD).priority(880.0f).build("climb_hold");

    public static void init() {
    }

    public static EntityActionTarget by(String name) {
        EntityActionTarget target = NAMED_ACTIONS.get(name);
        if (target != null) {
            return target;
        }
        return new EntityActionTarget.Builder().build(name);
    }

    private static Builder normal() {
        return new Builder();
    }

    protected static class Builder
    extends EntityActionTarget.Builder {
        protected Builder() {
        }

        @Override
        public EntityActionTarget build(String name) {
            EntityActionTarget target = super.build(name);
            NAMED_ACTIONS.put(name, target);
            return target;
        }
    }
}

