/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.api.core.math.IVector3i;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenVector3f
implements Comparable<OpenVector3f>,
IVector3f {
    public static final int BYTES = 12;
    public static OpenVector3f ZERO = new OpenVector3f(0.0f, 0.0f, 0.0f);
    public static OpenVector3f ONE = new OpenVector3f(1.0f, 1.0f, 1.0f);
    public static OpenVector3f XN = new OpenVector3f(-1.0f, 0.0f, 0.0f);
    public static OpenVector3f XP = new OpenVector3f(1.0f, 0.0f, 0.0f);
    public static OpenVector3f YN = new OpenVector3f(0.0f, -1.0f, 0.0f);
    public static OpenVector3f YP = new OpenVector3f(0.0f, 1.0f, 0.0f);
    public static OpenVector3f ZN = new OpenVector3f(0.0f, 0.0f, -1.0f);
    public static OpenVector3f ZP = new OpenVector3f(0.0f, 0.0f, 1.0f);
    public static final IDataCodec<OpenVector3f> CODEC = IDataCodec.FLOAT.listOf().xmap(OpenVector3f::new, OpenVector3f::toList);
    public float x;
    public float y;
    public float z;

    public OpenVector3f() {
    }

    public OpenVector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public OpenVector3f(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public OpenVector3f(IVector3f pos) {
        this(pos.x(), pos.y(), pos.z());
    }

    public OpenVector3f(IVector3i pos) {
        this(pos.x(), pos.y(), pos.z());
    }

    public OpenVector3f(List<Float> values) {
        this(values.get(0).floatValue(), values.get(1).floatValue(), values.get(2).floatValue());
    }

    public OpenVector3f(float[] values) {
        this.set(values);
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(OpenVector3f pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public void set(float[] values) {
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    public void add(float tx, float ty, float tz) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
    }

    public void add(OpenVector3f pos) {
        this.x += pos.x;
        this.y += pos.y;
        this.z += pos.z;
    }

    public void subtract(float tx, float ty, float tz) {
        this.x -= tx;
        this.y -= ty;
        this.z -= tz;
    }

    public void subtract(OpenVector3f pos) {
        this.x -= pos.x;
        this.y -= pos.y;
        this.z -= pos.z;
    }

    public void scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    public void scale(float sx, float sy, float sz) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
    }

    public void scale(OpenVector3f pos) {
        this.x *= pos.x;
        this.y *= pos.y;
        this.z *= pos.z;
    }

    public void transform(IMatrix3f mat) {
        float[] floats = new float[]{this.x, this.y, this.z};
        mat.multiply(floats);
        this.set(floats[0], floats[1], floats[2]);
    }

    public void transform(IMatrix4f mat) {
        float[] floats = new float[]{this.x, this.y, this.z, 1.0f};
        mat.multiply(floats);
        this.set(floats[0], floats[1], floats[2]);
    }

    public void transform(OpenQuaternionf value) {
        OpenQuaternionf quaternion = new OpenQuaternionf(value);
        quaternion.mul(new OpenQuaternionf(this.x, this.y, this.z, 0.0f));
        OpenQuaternionf quaternion1 = new OpenQuaternionf(value);
        quaternion1.conjugate();
        quaternion.mul(quaternion1);
        this.set(quaternion.x(), quaternion.y(), quaternion.z());
    }

    public void normalize() {
        float scalar = OpenMath.invsqrt(OpenMath.fma(this.x, this.x, OpenMath.fma(this.y, this.y, this.z * this.z)));
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void cross(OpenVector3f pos) {
        float ax = this.x;
        float ay = this.y;
        float az = this.z;
        float bx = pos.x();
        float by = pos.y();
        float bz = pos.z();
        this.x = ay * bz - az * by;
        this.y = az * bx - ax * bz;
        this.z = ax * by - ay * bx;
    }

    public void clamp(float minValue, float maxValue) {
        this.x = OpenMath.clamp(this.x, minValue, maxValue);
        this.y = OpenMath.clamp(this.y, minValue, maxValue);
        this.z = OpenMath.clamp(this.z, minValue, maxValue);
    }

    public void lerp(OpenVector3f pos, float f) {
        float f1 = 1.0f - f;
        this.x = this.x * f1 + pos.x * f;
        this.y = this.y * f1 + pos.y * f;
        this.z = this.z * f1 + pos.z * f;
    }

    public float dot(OpenVector3f pos) {
        return this.x * pos.x + this.y * pos.y + this.z * pos.z;
    }

    public float length() {
        return OpenMath.sqrt(OpenMath.fma(this.x, this.x, OpenMath.fma(this.y, this.y, this.z * this.z)));
    }

    public float distanceTo(OpenVector3f pos) {
        return OpenMath.sqrt(this.distanceToSquared(pos));
    }

    public float distanceToSquared(OpenVector3f pos) {
        return this.distanceToSquared(pos.x, pos.y, pos.z);
    }

    public float distanceToSquared(float tx, float ty, float tz) {
        float dx = this.x - tx;
        float dy = this.y - ty;
        float dz = this.z - tz;
        return OpenMath.fma(dx, dx, OpenMath.fma(dy, dy, dz * dz));
    }

    public OpenQuaternionf rotation(float f) {
        return new OpenQuaternionf(this, f, false);
    }

    public OpenQuaternionf rotationDegrees(float f) {
        return new OpenQuaternionf(this, f, true);
    }

    public OpenVector3f adding(float tx, float ty, float tz) {
        OpenVector3f ret = this.copy();
        ret.add(tx, ty, tz);
        return ret;
    }

    public OpenVector3f adding(OpenVector3f pos) {
        OpenVector3f ret = this.copy();
        ret.add(pos);
        return ret;
    }

    public OpenVector3f subtracting(float tx, float ty, float tz) {
        OpenVector3f ret = this.copy();
        ret.subtract(tx, ty, tz);
        return ret;
    }

    public OpenVector3f subtracting(OpenVector3f pos) {
        OpenVector3f ret = this.copy();
        ret.subtract(pos);
        return ret;
    }

    public OpenVector3f scaling(float scale) {
        OpenVector3f ret = this.copy();
        ret.scale(scale);
        return ret;
    }

    public OpenVector3f scaling(float sx, float sy, float sz) {
        OpenVector3f ret = this.copy();
        ret.scale(sx, sy, sz);
        return ret;
    }

    public OpenVector3f scaling(OpenVector3f pos) {
        OpenVector3f ret = this.copy();
        ret.scale(pos);
        return ret;
    }

    public OpenVector3f transforming(IMatrix3f mat) {
        OpenVector3f ret = this.copy();
        ret.transform(mat);
        return ret;
    }

    public OpenVector3f transforming(IMatrix4f mat) {
        OpenVector3f ret = this.copy();
        ret.transform(mat);
        return ret;
    }

    public OpenVector3f transforming(OpenQuaternionf value) {
        OpenVector3f ret = this.copy();
        ret.transform(value);
        return ret;
    }

    public OpenVector3f normalizing() {
        OpenVector3f ret = this.copy();
        ret.normalize();
        return ret;
    }

    public OpenVector3f crossing(OpenVector3f pos) {
        OpenVector3f ret = this.copy();
        ret.cross(pos);
        return ret;
    }

    public OpenVector3f clamping(float minValue, float maxValue) {
        OpenVector3f ret = this.copy();
        ret.clamp(minValue, maxValue);
        return ret;
    }

    public OpenVector3f copy() {
        return new OpenVector3f(this.x, this.y, this.z);
    }

    public List<Float> toList() {
        return Collections.newList(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    @Override
    public int compareTo(OpenVector3f v) {
        int dy = Float.compare(this.y(), v.y());
        if (dy != 0) {
            return dy;
        }
        int dz = Float.compare(this.z(), v.z());
        if (dz != 0) {
            return dz;
        }
        return Float.compare(this.x(), v.x());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenVector3f)) {
            return false;
        }
        OpenVector3f that = (OpenVector3f)o;
        return Float.compare(this.x, that.x) == 0 && Float.compare(this.y, that.y) == 0 && Float.compare(this.z, that.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public String toString() {
        return OpenMath.format("(%f %f %f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

