/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobeMenu
extends AbstractContainerMenu {
    private final Player player;
    private final SkinWardrobe wardrobe;
    private final ArrayList<ItemStack> lastSyncSlot = new ArrayList();
    private final ArrayList<Slot> customSlots = new ArrayList();
    private final int slotsX = 83;
    private final int slotsY = 27;
    private Group group = null;

    public SkinWardrobeMenu(MenuType<?> menuType, int containerId, Inventory inventory, SkinWardrobe wardrobe) {
        super(menuType, containerId);
        this.wardrobe = wardrobe;
        this.player = inventory.f_35978_;
        this.addPlayerSlots((Container)inventory, 59, 168, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addSkinSlots(SkinSlotType.HEAD, Group.SKINS, 0, 0);
        this.addSkinSlots(SkinSlotType.CHEST, Group.SKINS, 0, 1);
        this.addSkinSlots(SkinSlotType.LEGS, Group.SKINS, 0, 2);
        this.addSkinSlots(SkinSlotType.FEET, Group.SKINS, 0, 3);
        this.addSkinSlots(SkinSlotType.WINGS, Group.SKINS, 0, 4);
        this.addEquipmentSlots(Group.SKINS, 0, 5);
        this.addSkinSlots(SkinSlotType.OUTFIT, Group.OUTFITS, 0, 0);
        this.addSkinSlots(SkinSlotType.BACKPACK, Group.OUTFITS, 0, 5);
        this.addSkinSlots(SkinSlotType.HORSE, Group.UNKNOWN, 0, 0);
        this.addSkinSlots(SkinSlotType.DYE, Group.DYES, 0, 0);
        this.addMannequinSlots(Group.SKINS, 0, 5);
    }

    protected void addEquipmentSlots(Group group, int column, int row) {
        SkinSlotType[] slotTypes = new SkinSlotType[]{SkinSlotType.SWORD, SkinSlotType.SHIELD, SkinSlotType.BOW, SkinSlotType.TRIDENT, null, SkinSlotType.PICKAXE, SkinSlotType.AXE, SkinSlotType.SHOVEL, SkinSlotType.HOE};
        boolean hasContents = false;
        for (SkinSlotType slotType : slotTypes) {
            if (slotType != null) {
                int count = this.wardrobe.getUnlockedSize(slotType);
                if (count <= 0) continue;
                hasContents = true;
                this.addSkinSlots(slotType, group, column, row);
                column += count;
                continue;
            }
            if (!hasContents) continue;
            ++column;
        }
    }

    protected void addMannequinSlots(Group group, int column, int row) {
        Entity entity = this.wardrobe.entity();
        if (entity instanceof MannequinEntity) {
            MannequinEntity entity2 = (MannequinEntity)entity;
            Container inventory = entity2.getInventory();
            int size = inventory.m_6643_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                int x = 83 + (column + (size - i - 1)) * 19;
                int y = 27 + row * 19;
                SkinSlot slot = this.addGroupSlot(inventory, i, x, y, group, new SkinSlotType[0]);
                this.customSlots.add(slot);
            }
        }
    }

    protected void addSkinSlots(SkinSlotType slotType, Group group, int column, int row) {
        int index = slotType.index();
        int size = this.wardrobe.getUnlockedSize(slotType);
        Container inventory = this.wardrobe.inventory();
        for (int i = 0; i < size; ++i) {
            int x = 83 + (column + i) * 19;
            int y = 27 + row * 19;
            SkinSlot slot = this.addGroupSlot(inventory, index + i, x, y, group, slotType);
            this.customSlots.add(slot);
        }
    }

    protected SkinSlot addGroupSlot(Container inventory, int index, int x, int y, final Group group, SkinSlotType ... slotTypes) {
        SkinSlot slot = new SkinSlot(inventory, index, x, y, slotTypes){

            public boolean m_6659_() {
                return SkinWardrobeMenu.this.group() == group;
            }

            @Override
            public boolean m_5857_(ItemStack itemStack) {
                if (ModConfig.Common.onlySkinIntoSlots && !itemStack.m_150930_((Item)ModItems.SKIN.get())) {
                    return false;
                }
                return super.m_5857_(itemStack);
            }
        };
        this.m_38897_(slot);
        return slot;
    }

    public List<Slot> customSlots() {
        return this.customSlots;
    }

    public void forEachCustomSlots(Consumer<Slot> consumer) {
        for (Slot slot : this.customSlots) {
            if (!slot.m_6659_()) continue;
            consumer.accept(slot);
        }
    }

    public boolean m_6875_(Player player) {
        Entity entity = this.entity();
        if (entity == null || !entity.m_6084_() || !this.wardrobe.isEditable(player)) {
            return false;
        }
        return entity.m_20275_(player.m_20185_(), player.m_20186_(), player.m_20189_()) <= 64.0;
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (slot instanceof SkinSlot) {
            if (!this.m_38903_(itemStack, 9, 36, false) && !this.m_38903_(itemStack, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            slot.m_5852_(ItemStack.f_41583_);
            return itemStack.m_41777_();
        }
        SkinSlotType slotType = SkinSlotType.byItem(itemStack);
        if (slotType != null && this.wardrobe.isSupported(slotType)) {
            int startIndex = this.getFreeSlot(slotType);
            if (!this.m_38903_(itemStack, startIndex, startIndex + 1, false)) {
                return ItemStack.f_41583_;
            }
            slot.m_5852_(ItemStack.f_41583_);
            return itemStack.m_41777_();
        }
        if (this.wardrobe.entity() instanceof MannequinEntity) {
            int startIndex = this.getFreeSlot(SkinSlotType.ANY);
            if (!this.m_38903_(itemStack, startIndex, startIndex + 1, false)) {
                return ItemStack.f_41583_;
            }
            slot.m_5852_(ItemStack.f_41583_);
            return itemStack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        if (this.lastSyncSlot.size() != this.f_38839_.size()) {
            this.lastSyncSlot.ensureCapacity(this.f_38839_.size());
            this.f_38839_.forEach(s -> this.lastSyncSlot.add(s.m_7993_()));
            return;
        }
        int changes = 0;
        for (int index = 0; index < this.f_38839_.size(); ++index) {
            if (index < 36) continue;
            ItemStack newItemStack = ((Slot)this.f_38839_.get(index)).m_7993_();
            if (this.lastSyncSlot.get(index).equals(newItemStack)) continue;
            this.lastSyncSlot.set(index, newItemStack);
            ++changes;
        }
        if (changes != 0) {
            ModLog.debug("observer slots has {} changes, sync to players", changes);
            this.wardrobe.broadcast();
        }
    }

    public boolean shouldRenderInventory() {
        return this.group != null && this.group.shouldRenderInventory();
    }

    private int getFreeSlot(SkinSlotType slotType) {
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof SkinSlot)) continue;
            SkinSlot slot1 = (SkinSlot)slot;
            if (slot.m_6657_() || !slot1.slotTypes().contains((Object)slotType) && !slot1.slotTypes().isEmpty()) continue;
            return slot1.f_40219_;
        }
        return 0;
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public SkinWardrobe wardrobe() {
        return this.wardrobe;
    }

    @Nullable
    public Entity entity() {
        return this.wardrobe.entity();
    }

    public static enum Group {
        SKINS(true, 99),
        OUTFITS(true, 99),
        UNKNOWN(true, 99),
        DYES(true, 99),
        COLORS(false, 99);

        private final boolean exchanges;
        private final int extendedHeight;

        private Group(boolean exchanges, int extendedHeight) {
            this.exchanges = exchanges;
            this.extendedHeight = extendedHeight;
        }

        public boolean shouldRenderInventory() {
            return this.exchanges;
        }

        public int extendedHeight() {
            return this.extendedHeight;
        }
    }
}

