/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.blockentity.SkinningTableBlockEntity;
import moe.plushie.armourers_workshop.core.menu.SkinningTableMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateSkinningTablePacket
extends CustomPacket {
    private final BlockPos pos;
    private final SkinDescriptor.Options options;

    public UpdateSkinningTablePacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.options = buffer.readNbtWithCodec(SkinDescriptor.Options.CODEC);
    }

    public UpdateSkinningTablePacket(SkinningTableBlockEntity entity, SkinDescriptor.Options options) {
        this.pos = entity.m_58899_();
        this.options = options;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNbtWithCodec(SkinDescriptor.Options.CODEC, this.options);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        this.apply(player, false);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        this.apply((Player)player, true);
    }

    private void apply(Player player, boolean needForwarding) {
        BlockEntity entity = player.m_9236_().m_7702_(this.pos);
        if (entity instanceof SkinningTableBlockEntity) {
            SkinningTableBlockEntity blockEntity = (SkinningTableBlockEntity)entity;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof SkinningTableMenu) {
                SkinningTableMenu menu = (SkinningTableMenu)abstractContainerMenu;
                blockEntity.setOptions(this.options);
                menu.onCraftSlotChanges();
                if (needForwarding) {
                    NetworkManager.sendToTrackingBlock(this, blockEntity);
                }
            }
        }
    }
}

