/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core.ast;

import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import moe.plushie.armourers_workshop.core.skin.molang.core.Assignable;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Optimizable;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.Visitor;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.PrettyPrinter;
import moe.plushie.armourers_workshop.init.ModLog;

public final class Binary
implements Expression,
Optimizable {
    private final Operator op;
    private final Expression left;
    private final Expression right;
    private final Evaluator evaluator;

    public Binary(Operator op, Expression left, Expression rhs) {
        this.op = op;
        this.left = left;
        this.right = rhs;
        this.evaluator = op.evaluator;
    }

    @Override
    public Result evaluate(ExecutionContext context) {
        return this.evaluator.evaluate(context, this.left, this.right);
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitBinary(this);
    }

    @Override
    public boolean isMutable() {
        return this.left.isMutable() || this.right.isMutable();
    }

    public String toString() {
        return PrettyPrinter.toString(this);
    }

    public Operator op() {
        return this.op;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public static enum Operator {
        AND("&&", 1800, Operator.logical((lhs, rhs) -> lhs.getAsBoolean() && rhs.getAsBoolean())),
        OR("||", 1600, Operator.logical((lhs, rhs) -> lhs.getAsBoolean() || rhs.getAsBoolean())),
        LT("<", 2200, Operator.compare((lhs, rhs) -> lhs.getAsDouble() < rhs.getAsDouble())),
        LTE("<=", 2200, Operator.compare((lhs, rhs) -> lhs.getAsDouble() <= rhs.getAsDouble())),
        GT(">", 2200, Operator.compare((lhs, rhs) -> lhs.getAsDouble() > rhs.getAsDouble())),
        GTE(">=", 2200, Operator.compare((lhs, rhs) -> lhs.getAsDouble() >= rhs.getAsDouble())),
        ADD("+", 2400, Operator.arithmetic(MathHelper::add)),
        SUB("-", 2400, Operator.arithmetic(MathHelper::sub)),
        MUL("*", 2600, Operator.arithmetic(MathHelper::mul)),
        DIV("/", 2600, Operator.arithmetic(MathHelper::div)),
        MOD("%", 2600, Operator.arithmetic(MathHelper::mod)),
        POW("^", 2600, Operator.arithmetic(MathHelper::pow)),
        ARROW("->", 3000, (context, lhs, rhs) -> {
            Result result = lhs.evaluate(context);
            if (result.isValid()) {
                return rhs.evaluate(context.fork(result.getAsReference()));
            }
            return Result.NULL;
        }),
        NULL_COALESCE("??", 1200, (context, lhs, rhs) -> {
            Result result = lhs.evaluate(context);
            if (result.isValid()) {
                return result;
            }
            return rhs.evaluate(context);
        }),
        ASSIGN("=", 1000, (context, lhs, rhs) -> {
            if (!(lhs instanceof Assignable)) {
                ModLog.warn("Cannot assign a value to {}", lhs);
                return Result.NULL;
            }
            Assignable variable = (Assignable)lhs;
            Result result = rhs.evaluate(context);
            if (result.isStruct()) {
                result = result.copy();
            }
            return variable.assign(result, context);
        }),
        ADD_ASSIGN("+=", 1000, Operator.selfAssignArithmetic(MathHelper::add)),
        SUB_ASSIGN("-=", 1000, Operator.selfAssignArithmetic(MathHelper::sub)),
        MUL_ASSIGN("*=", 1000, Operator.selfAssignArithmetic(MathHelper::mul)),
        DIV_ASSIGN("/=", 1000, Operator.selfAssignArithmetic(MathHelper::div)),
        MOD_ASSIGN("%=", 1000, Operator.selfAssignArithmetic(MathHelper::mod)),
        POW_ASSIGN("^=", 1000, Operator.selfAssignArithmetic(MathHelper::pow)),
        NULL_COALESCE_ASSIGN("??=", 1000, (context, lhs, rhs) -> {
            Result result = lhs.evaluate(context);
            if (result.isValid()) {
                return result;
            }
            if (!(lhs instanceof Assignable)) {
                ModLog.warn("Cannot assign a value to {}", lhs);
                return Result.NULL;
            }
            Assignable variable = (Assignable)lhs;
            result = rhs.evaluate(context);
            if (result.isStruct()) {
                result = result.copy();
            }
            return variable.assign(result, context);
        }),
        CONDITIONAL("?", 1400, (context, lhs, rhs) -> {
            if (lhs.test(context)) {
                return rhs.evaluate(context);
            }
            return Result.NULL;
        }),
        EQ("==", 2000, Operator.compare(Result::equals)),
        NEQ("!=", 2000, Operator.compare(Result::notEquals));

        private final String symbol;
        private final Evaluator evaluator;
        private final int precedence;

        private Operator(String symbol, int precedence, Evaluator evaluator) {
            this.symbol = symbol;
            this.evaluator = evaluator;
            this.precedence = precedence;
        }

        private static Evaluator compare(BiFunction<Result, Result, Boolean> evaluator) {
            return (context, lhs, rhs) -> {
                Boolean result = (Boolean)evaluator.apply(lhs.evaluate(context), rhs.evaluate(context));
                return Result.valueOf(result);
            };
        }

        private static Evaluator logical(BiFunction<BooleanSupplier, BooleanSupplier, Boolean> evaluator) {
            return (context, lhs, rhs) -> {
                Boolean result = (Boolean)evaluator.apply(() -> lhs.test(context), () -> rhs.test(context));
                return Result.valueOf(result);
            };
        }

        private static Evaluator arithmetic(BiFunction<Result, Result, Result> evaluator) {
            return (context, lhs, rhs) -> (Result)evaluator.apply(lhs.evaluate(context), rhs.evaluate(context));
        }

        private static Evaluator selfAssignArithmetic(BiFunction<Result, Result, Result> evaluator) {
            return (context, lhs, rhs) -> {
                if (!(lhs instanceof Assignable)) {
                    ModLog.warn("Cannot assign a value to {}", lhs);
                    return Result.NULL;
                }
                Assignable variable = (Assignable)lhs;
                Result b = rhs.evaluate(context);
                return variable.assign(a -> (Result)evaluator.apply((Result)a, b), context);
            };
        }

        public String symbol() {
            return this.symbol;
        }

        public int precedence() {
            return this.precedence;
        }
    }

    public static interface Evaluator {
        public Result evaluate(ExecutionContext var1, Expression var2, Expression var3);
    }
}

