/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterOnceLifetime
extends SkinParticleComponent {
    private final OpenPrimitive activeTime;

    public EmitterOnceLifetime(OpenPrimitive activeTime) {
        this.activeTime = activeTime;
    }

    public EmitterOnceLifetime(IInputStream stream) throws IOException {
        this.activeTime = stream.readPrimitiveObject();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.activeTime);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression activeTime = builder.compile(this.activeTime, 10.0);
        builder.updateEmitter((emitter, context) -> {
            double active = activeTime.compute(context);
            emitter.setDuration(active);
            if (emitter.getTime() >= emitter.getDuration()) {
                emitter.stop();
            }
        });
    }
}

