/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterSteadyRate
extends SkinParticleComponent {
    private final OpenPrimitive spawnRate;
    private final OpenPrimitive maxParticles;

    public EmitterSteadyRate(OpenPrimitive spawnRate, OpenPrimitive maxParticles) {
        this.spawnRate = spawnRate;
        this.maxParticles = maxParticles;
    }

    public EmitterSteadyRate(IInputStream stream) throws IOException {
        this.spawnRate = stream.readPrimitiveObject();
        this.maxParticles = stream.readPrimitiveObject();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.spawnRate);
        stream.writePrimitiveObject(this.maxParticles);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression spawnRate = builder.compile(this.spawnRate, 1.0);
        Expression maxParticles = builder.compile(this.maxParticles, 50.0);
        builder.renderEmitterPost((emitter, partialTicks, context) -> {
            int size;
            if (!emitter.isRunning()) {
                return;
            }
            double rate = spawnRate.compute(context);
            double maxSize = maxParticles.compute(context);
            double targetSize = Math.ceil(rate * emitter.getTime());
            int i = size = emitter.getParticles().size();
            while ((double)i < targetSize && (double)i < maxSize) {
                emitter.spawnParticle();
                ++i;
            }
        });
    }
}

