/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterShapeDirection;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterDiscShape
extends SkinParticleComponent {
    private final OpenPrimitive x;
    private final OpenPrimitive y;
    private final OpenPrimitive z;
    private final OpenPrimitive radius;
    private final OpenPrimitive planeNormalX;
    private final OpenPrimitive planeNormalY;
    private final OpenPrimitive planeNormalZ;
    private final EmitterShapeDirection direction;
    private final boolean surface;

    public EmitterDiscShape(OpenPrimitive x, OpenPrimitive y, OpenPrimitive z, OpenPrimitive radius, OpenPrimitive planeNormalX, OpenPrimitive planeNormalY, OpenPrimitive planeNormalZ, EmitterShapeDirection direction, boolean surface) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.planeNormalX = planeNormalX;
        this.planeNormalY = planeNormalY;
        this.planeNormalZ = planeNormalZ;
        this.direction = direction;
        this.surface = surface;
    }

    public EmitterDiscShape(IInputStream stream) throws IOException {
        this.x = stream.readPrimitiveObject();
        this.y = stream.readPrimitiveObject();
        this.z = stream.readPrimitiveObject();
        this.radius = stream.readPrimitiveObject();
        this.planeNormalX = stream.readPrimitiveObject();
        this.planeNormalY = stream.readPrimitiveObject();
        this.planeNormalZ = stream.readPrimitiveObject();
        this.direction = EmitterShapeDirection.readFromStream(stream);
        this.surface = stream.readBoolean();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.x);
        stream.writePrimitiveObject(this.y);
        stream.writePrimitiveObject(this.z);
        stream.writePrimitiveObject(this.radius);
        stream.writePrimitiveObject(this.planeNormalX);
        stream.writePrimitiveObject(this.planeNormalY);
        stream.writePrimitiveObject(this.planeNormalZ);
        this.direction.writeToStream(stream);
        stream.writeBoolean(this.surface);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression x = builder.compile(this.x, 0.0);
        Expression y = builder.compile(this.y, 0.0);
        Expression z = builder.compile(this.z, 0.0);
        Expression radius = builder.compile(this.radius, 0.0);
        Expression normalX = builder.compile(this.planeNormalX, 0.0);
        Expression normalY = builder.compile(this.planeNormalY, 0.0);
        Expression normalZ = builder.compile(this.planeNormalZ, 0.0);
        builder.applyParticle((emitter, particle, context) -> {
            double cx = x.compute(context);
            double cy = y.compute(context);
            double cz = z.compute(context);
            double r = radius.compute(context);
            double nx = normalX.compute(context);
            double ny = normalY.compute(context);
            double nz = normalZ.compute(context);
        });
    }
}

