/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.world.level.block.Block;

public class ParticleOnlyInBlocksLifetime
extends SkinParticleComponent {
    private final List<String> blocks;

    public ParticleOnlyInBlocksLifetime(List<String> blocks) {
        this.blocks = blocks;
    }

    public ParticleOnlyInBlocksLifetime(IInputStream stream) throws IOException {
        int size = stream.readVarInt();
        ArrayList<String> blocks = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            blocks.add(stream.readString());
        }
        this.blocks = blocks;
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeVarInt(this.blocks.size());
        for (String block : this.blocks) {
            stream.writeString(block);
        }
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        ArrayList<Block> blocks = Collections.compactMap(this.blocks, builder::getBlock);
        builder.updateParticle((emitter, particle, context) -> {
            if (particle.isAlive() && !blocks.contains(particle.getBlock())) {
                particle.kill();
            }
        });
    }
}

