/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class OpenItemTransforms
extends LinkedHashMap<String, OpenTransform3f> {
    public static IDataCodec<OpenItemTransforms> CODEC = IDataCodec.COMPOUND_TAG.xmap(OpenItemTransforms::new, OpenItemTransforms::serializeNBT);

    public OpenItemTransforms() {
    }

    public OpenItemTransforms(CompoundTag nbt) {
        for (String key : OptionalAPI.keySet(nbt)) {
            OptionalAPI.getOptionalList(nbt, key, 5).ifPresent(values -> this.put(key, this.deserializeTransform((ListTag)values)));
        }
    }

    @Override
    public void put(OpenItemDisplayContext key, OpenTransform3f value) {
        this.put(key.serializedName(), value);
    }

    public OpenTransform3f get(OpenItemDisplayContext key) {
        return (OpenTransform3f)this.get(key.serializedName());
    }

    public void setOffset(OpenTransform3f offset) {
        this.put("offset", offset);
    }

    @Nullable
    public OpenTransform3f offset() {
        return (OpenTransform3f)this.get("offset");
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.forEach((key, value) -> nbt.m_128365_(key, (Tag)this.serializeTransform((OpenTransform3f)value)));
        return nbt;
    }

    private ListTag serializeTransform(OpenTransform3f transform) {
        ListTag tag = new ListTag();
        if (transform.isIdentity()) {
            return tag;
        }
        OpenVector3f translate = transform.translate();
        tag.add((Object)FloatTag.m_128566_((float)translate.x()));
        tag.add((Object)FloatTag.m_128566_((float)translate.y()));
        tag.add((Object)FloatTag.m_128566_((float)translate.z()));
        OpenVector3f rotation = transform.rotation();
        tag.add((Object)FloatTag.m_128566_((float)rotation.x()));
        tag.add((Object)FloatTag.m_128566_((float)rotation.y()));
        tag.add((Object)FloatTag.m_128566_((float)rotation.z()));
        OpenVector3f scale = transform.scale();
        tag.add((Object)FloatTag.m_128566_((float)scale.x()));
        tag.add((Object)FloatTag.m_128566_((float)scale.y()));
        tag.add((Object)FloatTag.m_128566_((float)scale.z()));
        return tag;
    }

    private OpenTransform3f deserializeTransform(ListTag tag) {
        if (tag.isEmpty() || tag.size() < 9) {
            return OpenTransform3f.IDENTITY;
        }
        Float tx = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 0).orElse(Float.valueOf(0.0f));
        Float ty = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 1).orElse(Float.valueOf(0.0f));
        Float tz = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 2).orElse(Float.valueOf(0.0f));
        OpenVector3f translate = new OpenVector3f(tx.floatValue(), ty.floatValue(), tz.floatValue());
        Float rx = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 3).orElse(Float.valueOf(0.0f));
        Float ry = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 4).orElse(Float.valueOf(0.0f));
        Float rz = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 5).orElse(Float.valueOf(0.0f));
        OpenVector3f rotation = new OpenVector3f(rx.floatValue(), ry.floatValue(), rz.floatValue());
        Float sx = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 6).orElse(Float.valueOf(0.0f));
        Float sy = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 7).orElse(Float.valueOf(0.0f));
        Float sz = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.ListTag.OptionalAPI.getOptionalFloat(tag, 8).orElse(Float.valueOf(0.0f));
        OpenVector3f scale = new OpenVector3f(sx.floatValue(), sy.floatValue(), sz.floatValue());
        return OpenTransform3f.create(translate, rotation, scale);
    }
}

