/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Minecraft.ItemModelProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModel;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModels;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinLightSource;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientDynamicLightHandler<T> {
    private static Entity TICKING_ENTITY;

    public static void init() {
        ModConfig.Client.enableDynamicLightHandler = true;
    }

    public static void startTick(Entity entity) {
        TICKING_ENTITY = entity;
    }

    public static void endTick(Entity entity) {
        TICKING_ENTITY = null;
    }

    public static SkinLightSource getLightSource(Entity entity) {
        SkinLightSource lightSource;
        if (!ModConfig.enableDynamicLightHandler()) {
            return null;
        }
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && (lightSource = renderData.lightSource()).isEnabled()) {
            return lightSource;
        }
        return null;
    }

    public static SkinLightSource getLightSource(BlockEntity entity) {
        SkinLightSource lightSource;
        if (!ModConfig.enableDynamicLightHandler()) {
            return null;
        }
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData != null && (lightSource = renderData.lightSource()).isEnabled()) {
            return lightSource;
        }
        return null;
    }

    public static SkinLightSource getLightSource(ItemStack itemStack, boolean submergedInWater) {
        BakedSkin bakedSkin;
        if (!ModConfig.enableDynamicLightHandler()) {
            return null;
        }
        EmbeddedItemModel itemModel = ClientDynamicLightHandler.getItemModel(itemStack);
        if (itemModel != null && (bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.INVENTORY.get(itemModel.sourceSkin()))) != null) {
            return bakedSkin.renderInfo().lightSource();
        }
        return null;
    }

    private static EmbeddedItemModel getItemModel(ItemStack itemStack) {
        Entity entity = TICKING_ENTITY;
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return ClientDynamicLightHandler.getItemModel(itemStack, entity2.m_9236_(), entity2);
        }
        return ClientDynamicLightHandler.getItemModel(itemStack, null, null);
    }

    private static EmbeddedItemModel getItemModel(ItemStack itemStack, @Nullable Level level, @Nullable LivingEntity entity) {
        BakedModel model = ItemModelProvider.getItemModel(EnvironmentManager.getClient(), itemStack, level, entity, 0);
        EmbeddedItemModels itemModels = EmbeddedItemModels.of(itemStack);
        return itemModels.get(model);
    }
}

