/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExecuteCommandPacket
extends CustomPacket {
    private static final List<Class<?>> SUPPORTED_CLASSES = Collections.immutableList(builder -> {
        builder.add(ModDebugger.class);
        builder.add(ModConfig.Client.class);
    });
    private final Class<?> object;
    private final Mode mode;
    private final String key;
    private final Object value;

    public ExecuteCommandPacket(Class<?> object, String key, Object value, Mode mode) {
        this.object = object;
        this.mode = mode;
        this.key = key;
        this.value = value;
    }

    public ExecuteCommandPacket(IFriendlyByteBuf buffer) {
        this.object = this.readClass(buffer);
        this.mode = buffer.readEnum(Mode.class);
        this.key = buffer.readUtf();
        this.value = this.readObject(buffer);
    }

    public static ExecuteCommandPacket set(Class<?> obj, String key, Object value) {
        return new ExecuteCommandPacket(obj, key, value, Mode.SET);
    }

    public static ExecuteCommandPacket get(Class<?> obj, String key) {
        return new ExecuteCommandPacket(obj, key, null, Mode.GET);
    }

    public static ExecuteCommandPacket invoke(Class<?> obj, String key, Object ... args) {
        return new ExecuteCommandPacket(obj, key, args, Mode.INVOKE);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeUtf(this.object.getName());
        buffer.writeEnum(this.mode);
        buffer.writeUtf(this.key);
        this.writeObject(buffer, this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        try {
            Object data = this.value;
            switch (this.mode.ordinal()) {
                case 1: {
                    Field field = this.object.getField(this.key);
                    data = field.get(this.object);
                    break;
                }
                case 0: {
                    Field field = this.object.getField(this.key);
                    field.set(this.object, data);
                    break;
                }
            }
            player.m_213846_((Component)Component.m_237113_((String)(this.key + " = " + String.valueOf(data))));
            if (ModDebugger.class == this.object) {
                ModDebugger.apply();
            }
            if (ModConfig.Client.class == this.object) {
                ModConfigSpec.CLIENT.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object readObject(IFriendlyByteBuf buffer) {
        Object object;
        if (this.mode != Mode.SET) {
            return null;
        }
        ObjectInputStream inputStream = new ObjectInputStream((InputStream)new ByteBufInputStream(buffer.asByteBuf()));
        try {
            object = inputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return exception;
            }
        }
        inputStream.close();
        return object;
    }

    private void writeObject(IFriendlyByteBuf buffer, Object object) {
        if (this.mode != Mode.SET) {
            return;
        }
        try (ObjectOutputStream outputStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buffer.asByteBuf()));){
            outputStream.writeObject(object);
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
        }
    }

    private Class<?> readClass(IFriendlyByteBuf buffer) {
        String name = buffer.readUtf();
        for (Class<?> clazz : SUPPORTED_CLASSES) {
            if (!name.equals(clazz.getName())) continue;
            return clazz;
        }
        return null;
    }

    public static enum Mode {
        SET,
        GET,
        INVOKE;

    }
}

