/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGRect;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.event.client.ItemTooltipEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.Strings;

@OnlyIn(value=Dist.CLIENT)
public class ItemTooltipManager {
    public static List<Component> createSkinInfo(BakedSkin bakedSkin) {
        Skin skin = bakedSkin.skin();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (Strings.isNotBlank((String)skin.customName().trim())) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinName", skin.customName().trim()));
        }
        if (Strings.isNotBlank((String)skin.authorName())) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinAuthor", skin.authorName().trim()));
        }
        tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinType", TranslateUtils.Name.of(skin.type())));
        if (ModDebugger.tooltip) {
            ItemTooltipManager.appendSettingInfo(tooltip, bakedSkin);
        }
        return tooltip;
    }

    public static List<Component> createSkinTooltip(ItemStack itemStack) {
        boolean isItemOwner = itemStack.m_150930_((Item)ModItems.SKIN.get());
        ArrayList<Component> tooltip = new ArrayList<Component>();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            if (isItemOwner) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinInvalidItem", new Object[0]));
            }
            return tooltip;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.TOOLTIP.get(descriptor));
        if (bakedSkin == null) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skindownloading", descriptor.identifier()));
            return tooltip;
        }
        Skin skin = bakedSkin.skin();
        SkinDescriptor.Options options = descriptor.options();
        SkinUsedCounter counter = bakedSkin.usedCounter();
        if (!isItemOwner) {
            if (options.contains(SkinDescriptor.TooltipFlags.HAS_SKIN)) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.hasSkin", new Object[0]));
            }
            if (options.contains(SkinDescriptor.TooltipFlags.NAME) && Strings.isNotBlank((String)skin.customName())) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinName", skin.customName().trim()));
            }
        }
        if (isItemOwner && options.contains(SkinDescriptor.TooltipFlags.FLAVOUR) && Strings.isNotBlank((String)skin.flavourText())) {
            tooltip.add((Component)TranslateUtils.title("item.armourers_workshop.rollover.flavour", skin.flavourText().trim()));
        }
        if (options.contains(SkinDescriptor.TooltipFlags.AUTHOR) && Strings.isNotBlank((String)skin.authorName())) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinAuthor", skin.authorName().trim()));
        }
        if (options.contains(SkinDescriptor.TooltipFlags.TYPE)) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinType", TranslateUtils.Name.of(skin.type())));
        }
        if (!isItemOwner && options.contains(SkinDescriptor.TooltipFlags.FLAVOUR) && Strings.isNotBlank((String)skin.flavourText())) {
            tooltip.add((Component)TranslateUtils.title("item.armourers_workshop.rollover.flavour", skin.flavourText().trim()));
        }
        if (ModDebugger.tooltip && !Screen.m_96638_()) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinHoldShiftForInfo", new Object[0]));
        }
        if (ModDebugger.tooltip && Screen.m_96638_()) {
            String totals = String.format("%d/%d/%d/%d", counter.getGeometryTotal(SkinGeometryTypes.BLOCK_SOLID), counter.getGeometryTotal(SkinGeometryTypes.BLOCK_GLOWING), counter.getGeometryTotal(SkinGeometryTypes.BLOCK_GLASS), counter.getGeometryTotal(SkinGeometryTypes.BLOCK_GLASS_GLOWING));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinIdentifier", descriptor.identifier()));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinTotalCubes", totals));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinDyeCount", counter.dyeTotal()));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinMarkerCount", counter.markerTotal()));
            if (skin.paintData() != null) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinPaintData", "64x32"));
            }
            if (ModDebugger.properties && !skin.properties().isEmpty()) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinProperties", new Object[0]));
                for (String prop : skin.properties().getPropertiesList()) {
                    tooltip.add((Component)Component.m_237113_((String)(" " + prop)));
                }
            }
            ItemTooltipManager.appendSettingInfo(tooltip, bakedSkin);
        }
        if (options.contains(SkinDescriptor.TooltipFlags.OPEN_WARDROBE) && isItemOwner && skin.type().isEquipment()) {
            Component keyName = ModKeyBindings.OPEN_WARDROBE_KEY.keyName();
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinOpenWardrobe", keyName));
        }
        return tooltip;
    }

    private static void appendSettingInfo(List<Component> tooltip, BakedSkin bakedSkin) {
        StringJoiner flags = new StringJoiner(",", "[", "]");
        SkinSettings settings = bakedSkin.skin().settings();
        if (!settings.isEditable()) {
            flags.add("NE");
        }
        if (!settings.isSavable()) {
            flags.add("NS");
        }
        if (!settings.isExportable()) {
            flags.add("NP");
        }
        if (settings.isEncrypted()) {
            flags.add("S");
        }
        if (settings.isCompressed()) {
            flags.add("C");
        }
        tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinSettings", flags.toString()));
    }

    public static void gatherSkinTooltip(ItemTooltipEvent.Gather event) {
        ItemStack itemStack = event.itemStack();
        List<Component> newTooltips = ItemTooltipManager.createSkinTooltip(itemStack);
        if (newTooltips.isEmpty()) {
            return;
        }
        List<Component> tooltips = event.tooltips();
        if (event.context().flags().m_7050_()) {
            String registryName = TypedRegistry.findKey(itemStack.m_41720_()).toString();
            for (int index = tooltips.size(); index > 0; --index) {
                Component text = tooltips.get(index - 1);
                if (!registryName.equals(text.getString())) continue;
                tooltips.addAll(index - 1, newTooltips);
                return;
            }
        }
        tooltips.addAll(newTooltips);
    }

    public static void renderSkinTooltip(ItemTooltipEvent.Render event) {
        float dy;
        float dx;
        if (!ModConfig.Client.skinPreEnabled) {
            return;
        }
        ItemStack itemStack = event.itemStack();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinDescriptor.Options options = descriptor.options();
        if (!options.contains(SkinDescriptor.TooltipFlags.PREVIEW)) {
            return;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.TOOLTIP.get(descriptor));
        if (bakedSkin == null) {
            return;
        }
        CGRect frame = event.frame();
        CGGraphicsContext context = event.context();
        float screenHeight = event.screenHeight();
        float screenWidth = event.screenWidth();
        float size = ModConfig.Client.skinPreSize;
        if (ModConfig.Client.skinPreLocFollowMouse) {
            dx = frame.x - 28.0f - size;
            dy = frame.y - 4.0f;
            if (frame.x < context.state().mousePos().x()) {
                dx = frame.x + frame.width + 28.0f;
            }
            dy = OpenMath.clamp(dy, 0.0f, screenHeight - size);
        } else {
            dx = OpenMath.ceili((double)(screenWidth - size) * ModConfig.Client.skinPreLocHorizontal);
            dy = OpenMath.ceili((double)(screenHeight - size) * ModConfig.Client.skinPreLocVertical);
        }
        if (ModConfig.Client.skinPreDrawBackground) {
            context.drawTilableImage(ModTextures.GUI_PREVIEW, dx, dy, size, size, 0.0f, 0.0f, 62.0f, 62.0f, 4.0f, 4.0f, 4.0f, 4.0f, 400.0f);
        }
        SkinPaintScheme colorScheme = descriptor.paintScheme();
        AbstractBufferSource buffers = AbstractBufferSource.buffer();
        ExtendedItemRenderer.renderSkinInTooltip(bakedSkin, colorScheme, itemStack, dx, dy, 500.0f, size, size, 30.0f, 45.0f, 0.0f, 0.0f, 0xF000F0, context.state().ctm(), buffers);
        buffers.endBatch();
    }
}

