/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRatingView
extends UIControl {
    private int value;
    private int maxValue;
    private int hoveredValue = -1;

    public SkinRatingView(CGRect frame) {
        super(frame);
        this.setMaxValue(10);
        this.setValue(7);
    }

    @Override
    public void mouseEntered(UIEvent event) {
        super.mouseEntered(event);
        this.hoveredValue = this.getRatingAtPos(event.locationInView(this));
    }

    @Override
    public void mouseMoved(UIEvent event) {
        super.mouseMoved(event);
        this.hoveredValue = this.getRatingAtPos(event.locationInView(this));
    }

    @Override
    public void mouseExited(UIEvent event) {
        super.mouseExited(event);
        this.hoveredValue = 0;
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        int value = this.getRatingAtPos(event.locationInView(this));
        if (value >= 0 && value <= this.maxValue()) {
            this.setValue(value);
            this.sendEvent(UIControl.Event.VALUE_CHANGED);
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        for (int i = 0; i < this.maxValue() / 2; ++i) {
            context.drawImage(ModTextures.RATING, i * 16, 0.0f, 16.0f, 16.0f, 32.0f, 0.0f, 256.0f, 256.0f);
        }
        int rating = this.value();
        if (this.isHighlighted()) {
            rating = this.hoveredValue;
        }
        int stars = OpenMath.floori((float)rating / 2.0f);
        int halfStar = rating % 2;
        for (int i = 0; i < stars; ++i) {
            context.drawImage(ModTextures.RATING, i * 16, 0.0f, 16.0f, 16.0f, 0.0f, 0.0f, 256.0f, 256.0f);
        }
        if (halfStar == 1) {
            context.drawImage(ModTextures.RATING, stars * 16, 0.0f, 8.0f, 16.0f, 0.0f, 0.0f, 256.0f, 256.0f);
        }
    }

    public int value() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = OpenMath.clamp(value, 0, this.maxValue());
    }

    public int maxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        CGRect frame = this.frame();
        this.maxValue = maxValue;
        this.setFrame(new CGRect(frame.x, frame.y, maxValue * 8, frame.height));
    }

    private int getRatingAtPos(CGPoint point) {
        return OpenMath.clamp(OpenMath.floori((point.x + 8.0f) / 8.0f), 0, this.maxValue);
    }
}

