/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.init.ModLog;

public class MinecraftAuth {
    private static final String JOIN_URL = "https://sessionserver.mojang.com/session/minecraft/join";
    private static final Object MC_AUTH_LOCK = new Object();
    private static long lastAuthTime;
    private static Exception lastAuthError;
    private static UserProvider USER_PROVIDER;

    public static void init(UserProvider userProvider) {
        USER_PROVIDER = userProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAndRefeshAuth(String serverId) {
        Object object = MC_AUTH_LOCK;
        synchronized (object) {
            if (lastAuthTime + 30000L > System.currentTimeMillis()) {
                ModLog.debug("skipping mc auth", new Object[0]);
                return true;
            }
            if (USER_PROVIDER == null) {
                ModLog.debug("pls call init before!!!", new Object[0]);
                lastAuthError = new RuntimeException("pls call init before!!!");
                return false;
            }
            ModLog.info("MC Auth Start", new Object[0]);
            String data = "{\"accessToken\":\"" + USER_PROVIDER.accessToken() + "\", \"serverId\":\"" + serverId + "\", \"selectedProfile\":\"" + USER_PROVIDER.id() + "\"}";
            try {
                IODataObject object2;
                String result = MinecraftAuth.performPostRequest(new URL(JOIN_URL), data, "application/json");
                if (result != null && !result.isEmpty() && (object2 = JsonSerializer.readFromString(result)).get("error") != null) {
                    throw new RuntimeException(object2.get("error").stringValue());
                }
                lastAuthTime = System.currentTimeMillis();
                return true;
            }
            catch (Exception e) {
                lastAuthError = e;
                return false;
            }
        }
    }

    public static Exception getLastError() {
        return lastAuthError;
    }

    private static String performPostRequest(URL url, String post, String contentType) throws IOException {
        String string;
        block16: {
            HttpURLConnection connection = MinecraftAuth.createUrlConnection(url);
            byte[] postAsBytes = post.getBytes(StandardCharsets.UTF_8);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
            connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
            connection.setDoOutput(true);
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(postAsBytes);
            }
            InputStream inputStream = connection.getInputStream();
            try {
                string = StreamUtils.readStreamToString(inputStream, StandardCharsets.UTF_8);
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    InputStream inputStream2 = connection.getErrorStream();
                    if (inputStream2 != null) {
                        return StreamUtils.readStreamToString(inputStream2, StandardCharsets.UTF_8);
                    }
                    throw e;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static HttpURLConnection createUrlConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }

    public static interface UserProvider {
        public String id();

        public String name();

        public String accessToken();
    }
}

