/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIMenuController;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentMinimapNode;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeIndexPath;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeNode;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeViewDelegate;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class DocumentMinimapView
extends UIView {
    private final TreeView treeView = new TreeView(new DocumentMinimapNode("Root"), this.bounds());

    public DocumentMinimapView(CGRect frame) {
        super(frame);
        this.treeView.setContentInsets(new UIEdgeInsets(4.0f, 0.0f, 4.0f, 0.0f));
        this.treeView.setAutoresizingMask(18);
        this.addSubview(this.treeView);
    }

    public void reloadData(SkinDocumentNode rootNode) {
        this._applyToSubviews(rootNode, this.treeView.rootNode(), (node, nodeView) -> {
            nodeView.setTitle(node.name());
            nodeView.setLocked(node.isLocked());
            nodeView.setContents(node);
        });
    }

    public DocumentMinimapNode findNode(SkinDocumentNode node) {
        TreeNode nodeView = this._findNode(node);
        return (DocumentMinimapNode)nodeView;
    }

    public TreeIndexPath findNodePath(SkinDocumentNode node) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (node != null) {
            SkinDocumentNode parent = node.parent();
            if (parent != null) {
                indexes.add(0, parent.children().indexOf(node));
            }
            node = parent;
        }
        return new TreeIndexPath(indexes);
    }

    public void setSelectedIndex(TreeIndexPath indexPath) {
        this.treeView.selectNode(this._findNode(indexPath));
    }

    public TreeIndexPath selectedIndex() {
        return this._findNodePath(this.treeView.selectedNode());
    }

    public void setDelegate(TreeViewDelegate delegate) {
        this.treeView.setDelegate(delegate);
    }

    public TreeViewDelegate delegate() {
        return this.treeView.delegate();
    }

    public void setMenuController(UIMenuController menuController) {
        this.treeView.setMenuController(menuController);
    }

    public UIMenuController menuController() {
        return this.treeView.menuController();
    }

    private TreeNode _findNode(SkinDocumentNode node) {
        SkinDocumentNode parent = node.parent();
        if (parent == null) {
            return this.treeView.rootNode();
        }
        TreeNode nodeView = this._findNode(parent);
        if (nodeView == null) {
            return null;
        }
        for (TreeNode childView : nodeView.children()) {
            if (childView.contents() != node) continue;
            return childView;
        }
        return null;
    }

    private TreeNode _findNode(TreeIndexPath indexPath) {
        List<Integer> indexes = indexPath.indexes();
        if (indexes.isEmpty()) {
            indexes = Collections.newList(0);
        }
        TreeNode node = this.treeView.rootNode();
        for (int index : indexes) {
            int size = node.children().size();
            if (size == 0) {
                return node;
            }
            if (index >= size) {
                return node.children().get(size - 1);
            }
            node = node.children().get(index);
        }
        return node;
    }

    private TreeIndexPath _findNodePath(TreeNode nodeView) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (nodeView != null) {
            TreeNode parentView = nodeView.parent();
            if (parentView != null) {
                indexes.add(0, parentView.children().indexOf(nodeView));
            }
            nodeView = parentView;
        }
        return new TreeIndexPath(indexes);
    }

    private void _applyToSubviews(SkinDocumentNode rootNode, TreeNode rootNodeView, BiConsumer<SkinDocumentNode, TreeNode> applier) {
        int i;
        ArrayList<SkinDocumentNode> children = rootNode.children();
        ArrayList<TreeNode> subviews = new ArrayList<TreeNode>(rootNodeView.children());
        int inputSize = children.size();
        int viewSize = subviews.size();
        for (i = 0; i < inputSize; ++i) {
            TreeNode nodeView;
            SkinDocumentNode node = (SkinDocumentNode)children.get(i);
            if (i < viewSize) {
                nodeView = subviews.get(i);
                applier.accept(node, nodeView);
            } else {
                nodeView = new DocumentMinimapNode("");
                applier.accept(node, nodeView);
                rootNodeView.add(nodeView);
            }
            this._applyToSubviews(node, nodeView, applier);
            if (!nodeView.children().isEmpty()) continue;
            nodeView.setFolding(false);
        }
        for (i = inputSize; i < viewSize; ++i) {
            TreeNode nodeView = subviews.get(i);
            nodeView.removeFromParent();
        }
    }
}

