/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockItem;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class SkinCubeItem
extends AbstractBlockItem
implements IItemPaintable,
IPaintToolPicker {
    public SkinCubeItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    @Override
    public class_1269 usePickTool(class_1937 level, class_2338 pos, OpenDirection dir, class_2586 blockEntity, class_1838 context) {
        class_1799 itemStack = context.method_8041();
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            this.setItemColor(itemStack, provider.color());
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    protected boolean method_7710(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1799 itemStack, class_2680 blockState) {
        class_2586 blockEntity = level.method_8321(pos);
        class_2487 entityTag = (class_2487)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (entityTag != null && blockEntity != null) {
            class_2487 newNBT = StorageAPI.saveFullData(blockEntity, level.method_30349());
            OptionalAPI.getOptionalCompound(entityTag, "Color").ifPresent(color -> newNBT.method_10566("Color", (class_2520)color));
            StorageAPI.loadFullData(blockEntity, newNBT, level.method_30349());
        }
        return super.method_7710(pos, level, player, itemStack, blockState);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void appendHoverText(class_1799 itemStack, List<class_2561> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        BlockPaintColor paintColor = this.getItemColors(itemStack);
        if (paintColor != null && paintColor.isPureColor()) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor.get(OpenDirection.NORTH), true));
        }
    }

    @Override
    public void setItemColor(class_1799 itemStack, SkinPaintColor paintColor) {
        class_2487 entityTag = new class_2487();
        class_2487 oldEntityTag = (class_2487)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (oldEntityTag != null) {
            entityTag.method_10543(oldEntityTag);
        }
        entityTag.method_10582("id", TypedRegistry.findKey(this.method_7711()).toString());
        BlockPaintColor color = new BlockPaintColor(paintColor);
        TagSerializer serializer = new TagSerializer();
        color.serialize(serializer);
        entityTag.method_10566("Color", (class_2520)serializer.tag());
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_FLAGS.get(), 1);
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get(), entityTag);
    }

    @Override
    public SkinPaintColor getItemColor(class_1799 itemStack) {
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), SkinPaintColor.WHITE);
    }

    @Nullable
    public BlockPaintColor getItemColors(class_1799 itemStack) {
        return ColorUtils.getBlockColor(itemStack);
    }
}

