/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class UpdateOutfitMakerPacket
extends CustomPacket {
    private final class_2338 pos;
    private final GenericValue<OutfitMakerBlockEntity, ?> fieldValue;

    public UpdateOutfitMakerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateOutfitMakerPacket(OutfitMakerBlockEntity entity, GenericValue<OutfitMakerBlockEntity, ?> fieldValue) {
        this.pos = entity.method_11016();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, class_3222 player) {
        GenericProperty<OutfitMakerBlockEntity, ?> genericProperty;
        OutfitMakerBlockEntity blockEntity1;
        block3: {
            block2: {
                class_2586 blockEntity = PropertyProvider.getLevel((class_1297)player).method_8321(this.pos);
                if (!(blockEntity instanceof OutfitMakerBlockEntity)) break block2;
                blockEntity1 = (OutfitMakerBlockEntity)blockEntity;
                genericProperty = this.fieldValue.property();
                if (genericProperty instanceof Field) break block3;
            }
            return;
        }
        Field field = (Field)genericProperty;
        BlockUtils.performBatch(() -> {
            try {
                field.apply(this, blockEntity1, player);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void craftItem(OutfitMakerBlockEntity blockEntity, class_3222 player) {
        if (!ModPermissions.OUTFIT_MAKER_MAKE.accept((class_1657)player)) {
            return;
        }
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof OutfitMakerMenu) {
            OutfitMakerMenu menu = (OutfitMakerMenu)class_17032;
            class_2487 nbt = (class_2487)this.fieldValue.value();
            GameProfile profile = DataSerializers.readGameProfile(nbt);
            menu.saveArmourItem((class_1657)player, profile);
        }
    }

    public static final class Field<T>
    extends GenericProperty<OutfitMakerBlockEntity, T> {
        private static final GenericProperties<OutfitMakerBlockEntity> TYPE = GenericProperties.of(OutfitMakerBlockEntity.class, UpdateOutfitMakerPacket::new);
        public static final Field<String> ITEM_NAME = Field.create(OutfitMakerBlockEntity::itemName, OutfitMakerBlockEntity::setItemName, DataSerializers.STRING);
        public static final Field<String> ITEM_FLAVOUR = Field.create(OutfitMakerBlockEntity::itemFlavour, OutfitMakerBlockEntity::setItemFlavour, DataSerializers.STRING);
        public static final Field<class_2487> ITEM_CRAFTING = Field.create(UpdateOutfitMakerPacket::craftItem, DataSerializers.COMPOUND_TAG);
        private FieldAction<T> action;

        private static <T> Field<T> create(FieldAction<T> action, IEntitySerializer<T> dataSerializer) {
            Field field = TYPE.create(dataSerializer).build(Field::new);
            field.action = action;
            return field;
        }

        private static <T> Field<T> create(Function<OutfitMakerBlockEntity, T> supplier, BiConsumer<OutfitMakerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
        }

        private void apply(UpdateOutfitMakerPacket packet, OutfitMakerBlockEntity blockEntity, class_3222 player) throws Exception {
            if (this.action != null) {
                this.action.accept(packet, blockEntity, player);
            } else {
                packet.fieldValue.apply(blockEntity);
            }
        }
    }

    public static interface FieldAction<T> {
        public void accept(UpdateOutfitMakerPacket var1, OutfitMakerBlockEntity var2, class_3222 var3) throws Exception;
    }
}

