/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.fabric;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.data.CapabilityStorage;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2591;

public class AbstractFabricCapabilityManager {
    public static <T> IRegistryHolder<IEntityCapability<T>> registerEntity(IResourceLocation registryName, Class<T> type, Function<class_1297, Optional<T>> factory) {
        IEntityCapability capabilityType = new IEntityCapability<T>(){

            @Override
            public Optional<T> get(class_1297 entity) {
                return CapabilityStorage.getCapability(entity, this);
            }
        };
        CapabilityStorage.registerCapability(registryName, capabilityType, factory);
        return TypedRegistry.Entry.ofValue(registryName, capabilityType);
    }

    public static <T> IRegistryHolder<IBlockEntityCapability<T>> registerBlockEntity(IResourceLocation registryName, Class<T> type, Function<class_1297, Optional<T>> factory) {
        BlockApiLookup<T, class_2350> api;
        if (registryName.equals(ModConstants.key("item"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractFabricCapabilityManager.createSidedCapability(registryName, ItemStorage.SIDED));
        }
        if (registryName.equals(ModConstants.key("fluid"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractFabricCapabilityManager.createSidedCapability(registryName, FluidStorage.SIDED));
        }
        if (registryName.equals(ModConstants.key("energy")) && (api = AbstractFabricCapabilityManager.findStaticField("team.reborn.energy.api.EnergyStorage", "SIDED")) != null) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractFabricCapabilityManager.createSidedCapability(registryName, api));
        }
        return null;
    }

    private static <T> IRegistryHolder<IBlockEntityCapability<T>> createSidedCapability(IResourceLocation registryName, BlockApiLookup<T, class_2350> apiLookup) {
        IBlockEntityCapability<Object> capability1 = (arg_0, arg_1, arg_2, arg_3, arg_4) -> apiLookup.find(arg_0, arg_1, arg_2, arg_3, arg_4);
        apiLookup.registerForBlockEntity((entity, context) -> entity.getCapability(capability1, (class_2350)context), (class_2591)((IBlockEntityType)ModBlockEntityTypes.SKINNABLE.get()).get());
        return TypedRegistry.Entry.castValue(registryName, capability1);
    }

    private static <T> BlockApiLookup<T, class_2350> findStaticField(String className, String fieldName) {
        try {
            Class<?> obj = Class.forName(className);
            Field field = obj.getDeclaredField(fieldName);
            return (BlockApiLookup)Objects.unsafeCast(field.get(obj));
        }
        catch (Exception e) {
            return null;
        }
    }
}

