/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.InvokerResult;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.TextureUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;

@Environment(value=EnvType.CLIENT)
public class SkinWardrobeColorSetting
extends SkinWardrobeBaseSetting {
    private final SkinWardrobe wardrobe;

    public SkinWardrobeColorSetting(SkinWardrobe wardrobe) {
        super("wardrobe.colour_settings");
        this.wardrobe = wardrobe;
        this.setup();
    }

    private void setup() {
        this.setupPaletteView();
        this.setupPickerView(SkinPaintTypes.SKIN, 83, 26, true);
        this.setupPickerView(SkinPaintTypes.HAIR, 83, 55, true);
        this.setupPickerView(SkinPaintTypes.EYES, 83, 84, true);
        this.setupPickerView(SkinPaintTypes.MISC_1, 178, 26, false);
        this.setupPickerView(SkinPaintTypes.MISC_2, 178, 55, false);
        this.setupPickerView(SkinPaintTypes.MISC_3, 178, 84, false);
        this.setupPickerView(SkinPaintTypes.MISC_4, 178, 113, false);
    }

    private void setupPickerView(SkinPaintType paintType, int x, int y, boolean enableAutoPick) {
        ColorPicker picker = new ColorPicker(paintType, new CGRect(x, y, 90.0f, 24.0f), enableAutoPick);
        this.addSubview(picker);
    }

    private void setupPaletteView() {
        UIView bg1 = new UIView(new CGRect(0.0f, 152.0f, 256.0f, 98.0f));
        UIView bg2 = new UIView(new CGRect(256.0f, 152.0f, 22.0f, 98.0f));
        bg1.setContents(UIImage.of(ModTextures.WARDROBE_1).uv(0.0f, 152.0f).build());
        bg2.setContents(UIImage.of(ModTextures.WARDROBE_2).uv(0.0f, 152.0f).build());
        this.insertViewAtIndex(bg2, 0);
        this.insertViewAtIndex(bg1, 0);
        UILabel label = new UILabel(new CGRect(6.0f, 5.0f, 100.0f, 9.0f));
        label.setText(this.getDisplayText("label.palette", new Object[0]));
        bg1.addSubview(label);
    }

    private class ColorPicker
    extends UIView {
        private final UILabel titleView;
        private final UIView colorView;
        private final int slot;
        private final SkinPaintType paintType;
        private SkinPaintColor color;
        private UIButton pickerButton;

        public ColorPicker(SkinPaintType paintType, CGRect frame, boolean enableAutoPick) {
            super(frame);
            this.titleView = new UILabel(CGRect.ZERO);
            this.colorView = new UIView(new CGRect(1.0f, 12.0f, 12.0f, 12.0f));
            this.paintType = paintType;
            this.slot = SkinSlotType.getDyeSlotIndex(paintType);
            this.updateColor(this.getColor());
            this.setup(paintType, enableAutoPick);
        }

        private void setup(SkinPaintType paintType, boolean enableAutoPick) {
            String name = paintType.registryName().path();
            this.titleView.setText(SkinWardrobeColorSetting.this.getDisplayText("label." + name, new Object[0]));
            this.titleView.setFrame(new CGRect(0.0f, 0.0f, this.bounds().width, 9.0f));
            this.addSubview(this.titleView);
            this.setupIconButton(16, 9, 144, 192, ColorPicker::start, "button." + name + ".select");
            this.setupIconButton(33, 9, 208, 160, ColorPicker::clear, "button." + name + ".clear");
            if (enableAutoPick) {
                this.setupIconButton(50, 9, 144, 208, ColorPicker::autoPick, "button." + name + ".auto");
            }
            UIView view = new UIView(new CGRect(0.0f, 11.0f, 14.0f, 14.0f));
            view.setContents(UIImage.of(ModTextures.WARDROBE_2).uv(242.0f, 166.0f).build());
            this.addSubview(view);
            this.addSubview(this.colorView);
        }

        private void setupIconButton(int x, int y, int u, int v, BiConsumer<ColorPicker, UIControl> consumer, String tooltip) {
            UIButton button = new UIButton(new CGRect(x, y, 16.0f, 16.0f));
            button.setBackgroundImage(ModTextures.defaultButtonImage(u, v), 7);
            button.setTooltip(SkinWardrobeColorSetting.this.getDisplayText(tooltip, new Object[0]));
            button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, consumer);
            this.addSubview(button);
        }

        public void start(UIControl control) {
            if (!(control instanceof UIButton)) {
                return;
            }
            UIButton button = (UIButton)control;
            button.setSelected(true);
            this.pickerButton = button;
            UIWindow window = this.window();
            if (window != null) {
                window.addGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ColorPicker::end);
                window.addGlobalTarget(this, UIControl.Event.MOUSE_MOVED, ColorPicker::update);
            }
        }

        public void update(UIEvent event) {
            UIWindow window = this.window();
            if (window == null) {
                return;
            }
            CGPoint point = event.locationInWindow();
            CGRect frame = window.frame();
            int rgb = RenderSystem.getPixelColor(point.x + frame.x, point.y + frame.y);
            this.updateColor(SkinPaintColor.of(rgb, SkinPaintTypes.NORMAL));
        }

        public void end(UIEvent event) {
            event.cancel(InvokerResult.FAIL);
            this.setColor(this.color);
            UIWindow window = this.window();
            if (window != null) {
                window.removeGlobalTarget(this, UIControl.Event.MOUSE_MOVED);
                window.removeGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN);
            }
        }

        private void clear(UIControl control) {
            this.setColor(SkinPaintColor.CLEAR);
        }

        private void autoPick(UIControl control) {
            OpenResourceLocation location = TextureUtils.getTexture(SkinWardrobeColorSetting.this.wardrobe.entity());
            if (location == null) {
                return;
            }
            BakedEntityTexture texture = EntityTextureLoader.getInstance().getTextureModel(location);
            if (texture != null) {
                this.setColor(this.getColorFromTexture(texture));
            } else {
                this.setColor(SkinPaintColor.WHITE);
            }
        }

        private SkinPaintColor getColorFromTexture(BakedEntityTexture texture) {
            if (texture == null) {
                return null;
            }
            ArrayList<SkinPaintColor> colors = new ArrayList<SkinPaintColor>();
            if (this.paintType == SkinPaintTypes.SKIN) {
                colors.add(texture.getColor(11, 13));
                colors.add(texture.getColor(12, 13));
            }
            if (this.paintType == SkinPaintTypes.HAIR) {
                colors.add(texture.getColor(11, 3));
                colors.add(texture.getColor(12, 3));
            }
            if (this.paintType == SkinPaintTypes.EYES) {
                colors.add(texture.getColor(10, 12));
                colors.add(texture.getColor(13, 12));
            }
            int r = 0;
            int g = 0;
            int b = 0;
            int c = 0;
            for (SkinPaintColor paintColor : colors) {
                if (paintColor == null) continue;
                r += paintColor.red();
                g += paintColor.green();
                b += paintColor.blue();
                ++c;
            }
            if (c == 0) {
                return null;
            }
            return SkinPaintColor.of(r / c, g / c, b / c, SkinPaintTypes.NORMAL);
        }

        private SkinPaintColor getColor() {
            class_1799 itemStack = SkinWardrobeColorSetting.this.wardrobe.inventory().method_5438(this.slot);
            return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), SkinPaintColor.CLEAR);
        }

        private void setColor(SkinPaintColor newValue) {
            if (this.pickerButton != null) {
                this.pickerButton.setSelected(false);
                this.pickerButton = null;
            }
            this.updateColor(newValue);
            if (Objects.equals(this.getColor(), newValue)) {
                return;
            }
            NetworkManager.sendToServer(UpdateWardrobePacket.dying(SkinWardrobeColorSetting.this.wardrobe, this.slot, newValue));
        }

        private void updateColor(SkinPaintColor paintColor) {
            this.color = paintColor;
            if (!paintColor.isEmpty()) {
                this.colorView.setBackgroundColor(UIColor.of(paintColor.argb()));
            } else {
                this.colorView.setBackgroundColor(null);
            }
        }
    }
}

