/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketHolder;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SkinIconView
extends UIControl {
    private SkinDescriptor descriptor = SkinDescriptor.EMPTY;
    private final TicketHolder tickets = new TicketHolder("SkinIconView");

    public SkinIconView(CGRect frame) {
        super(frame);
        this.setClipBounds(true);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.tickets.get(this.descriptor));
        if (bakedSkin == null) {
            return;
        }
        CGRect rect = this.bounds();
        float tx = rect.x;
        float ty = rect.y;
        float tw = rect.width;
        float th = rect.height;
        float si = Math.min(tw, th);
        IPoseStack poseStack = context.state().ctm();
        SkinPaintScheme colorScheme = this.descriptor.paintScheme();
        SkinItemSource itemSource = SkinItemSource.EMPTY;
        AbstractBufferSource buffers = AbstractBufferSource.buffer();
        poseStack.pushPose();
        poseStack.translate(tx + tw / 2.0f, ty + th / 2.0f, 200.0f);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.rotate(OpenVector3f.XP.rotationDegrees(30.0f));
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(135.0f));
        poseStack.scale(0.625f, 0.625f, 0.625f);
        poseStack.scale(si, si, si);
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, colorScheme, 0.0f, 0xF000F0, itemSource, poseStack, buffers);
        poseStack.popPose();
        buffers.endBatch();
    }

    public SkinDescriptor skin() {
        return this.descriptor;
    }

    public void setSkin(SkinDescriptor descriptor) {
        this.tickets.invalidate();
        this.descriptor = descriptor;
    }
}

