/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class SlotListView<M extends class_1703>
extends UIView {
    protected final M menu;
    protected final DelegateScreen<M> screen;
    private boolean isReady = false;

    public SlotListView(M menu, class_1661 inventory, CGRect frame) {
        super(frame);
        this.menu = menu;
        this.screen = new DelegateScreen<M>(menu, inventory, (class_2561)class_2561.method_43470((String)""));
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        UIWindow window = this.window();
        if (window != null) {
            this.screen.setup(this.convertRectToView(this.bounds(), null), window.bounds());
            this.isReady = true;
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        if (!this.isReady) {
            return;
        }
        int mouseX = (int)context.state().mousePos().x();
        int mouseY = (int)context.state().mousePos().y();
        CGPoint offset = this.screen.contentOffset();
        context.saveGraphicsState();
        context.translateCTM(-offset.x, -offset.y, 0.0f);
        this.screen.renderInView(this, 400, mouseX, mouseY, context.state().partialTicks(), context);
        context.restoreGraphicsState();
    }

    @Override
    public void mouseDown(UIEvent event) {
        CGPoint point = this.locationInScreen(event);
        this.screen.method_25402(point.x, point.y, event.key());
    }

    @Override
    public void mouseUp(UIEvent event) {
        CGPoint point = this.locationInScreen(event);
        this.screen.method_25406(point.x, point.y, event.key());
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.screen.method_25432();
    }

    public M menu() {
        return this.menu;
    }

    private CGPoint locationInScreen(UIEvent event) {
        CGPoint point = event.locationInWindow();
        UIWindow window = this.window();
        if (window != null) {
            CGRect frame = window.frame();
            return new CGPoint(point.x + frame.x, point.y + frame.y);
        }
        return point;
    }

    public static class DelegateScreen<M extends class_1703>
    extends AbstractMenuScreen<M> {
        private final class_1661 inventory;

        public DelegateScreen(M menu, class_1661 inventory, class_2561 component) {
            super(menu, inventory, component);
            this.inventory = inventory;
            this.method_25423(EnvironmentManager.getClient(), 640, 480);
        }

        @Override
        public void method_25419() {
        }

        public void setup(CGRect rect, CGRect bounds) {
            this.setContentSize(new CGSize(rect.width, rect.height));
            this.method_25410(EnvironmentManager.getClient(), (int)bounds.width, (int)bounds.height);
            this.setContentOffset(new CGPoint(rect.x, rect.y));
        }

        @Override
        public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
        }

        public void method_2383(class_1735 slot, int i, int j, class_1713 clickType) {
            if (slot != null) {
                this.field_2797.method_7593(slot.field_7874, j, clickType, this.inventory.field_7546);
            }
        }
    }
}

