/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import moe.plushie.armourers_workshop.api.common.IEntityDataBuilder;
import moe.plushie.armourers_workshop.api.common.IEntityHandler;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLivingEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.EntityDimensions.ABI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntitySerializers;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public class MannequinEntity
extends AbstractLivingEntity.ArmorStand
implements IEntityHandler,
IDataSerializable.Mutable {
    public static final class_2379 DEFAULT_HEAD_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    public static final class_2379 DEFAULT_BODY_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    public static final class_2379 DEFAULT_LEFT_ARM_POSE = new class_2379(-10.0f, 0.0f, -10.0f);
    public static final class_2379 DEFAULT_RIGHT_ARM_POSE = new class_2379(-15.0f, 0.0f, 10.0f);
    public static final class_2379 DEFAULT_LEFT_LEG_POSE = new class_2379(-1.0f, 0.0f, -1.0f);
    public static final class_2379 DEFAULT_RIGHT_LEG_POSE = new class_2379(1.0f, 0.0f, 1.0f);
    public static final class_4048 MARKER_DIMENSIONS = class_4048.method_18385((float)0.0f, (float)0.0f);
    public static final class_4048 BABY_DIMENSIONS = ABI.withEyeHeight(class_4048.method_18384((float)0.5f, (float)1.0f), 0.88f);
    public static final class_4048 STANDING_DIMENSIONS = ABI.withEyeHeight(class_4048.method_18384((float)0.6f, (float)1.88f), 1.62f);
    public static final class_2940<Boolean> DATA_IS_CHILD = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final class_2940<Boolean> DATA_IS_FLYING = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final class_2940<Boolean> DATA_IS_GHOST = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final class_2940<Boolean> DATA_IS_VISIBLE = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final class_2940<Float> DATA_SCALE = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.FLOAT);
    public static final class_2940<Boolean> DATA_EXTRA_RENDERER = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final class_2940<Boolean> DATA_NO_GRAVITY = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final class_2940<EntityTextureDescriptor> DATA_TEXTURE = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE);
    public static final class_2940<EntityTextureDescriptor.Model> DATA_TEXTURE_MODEL = class_2945.method_12791(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE_MODEL);
    private boolean isDropEquipment = false;
    private class_238 boundingBoxForCulling;

    public MannequinEntity(class_1299<? extends MannequinEntity> entityType, class_1937 level) {
        super((class_1299<? extends AbstractLivingEntity.ArmorStand>)entityType, level);
    }

    @Override
    protected void defineSynchedData(IEntityDataBuilder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHILD, false);
        builder.define(DATA_IS_FLYING, false);
        builder.define(DATA_IS_GHOST, false);
        builder.define(DATA_IS_VISIBLE, true);
        builder.define(DATA_EXTRA_RENDERER, true);
        builder.define(DATA_NO_GRAVITY, true);
        builder.define(DATA_SCALE, Float.valueOf(1.0f));
        builder.define(DATA_TEXTURE, EntityTextureDescriptor.EMPTY);
        builder.define(DATA_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.deserialize(new TagSerializer(tag));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.serialize(new TagSerializer(tag));
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.IS_SMALL, (Boolean)this.field_6011.method_12789(DATA_IS_CHILD));
        serializer.write(CodingKeys.IS_FLYING, (Boolean)this.field_6011.method_12789(DATA_IS_FLYING));
        serializer.write(CodingKeys.IS_GHOST, (Boolean)this.field_6011.method_12789(DATA_IS_GHOST));
        serializer.write(CodingKeys.IS_VISIBLE, (Boolean)this.field_6011.method_12789(DATA_IS_VISIBLE));
        serializer.write(CodingKeys.EXTRA_RENDER, (Boolean)this.field_6011.method_12789(DATA_EXTRA_RENDERER));
        serializer.write(CodingKeys.NO_GRAVITY, (Boolean)this.field_6011.method_12789(DATA_NO_GRAVITY));
        serializer.write(CodingKeys.SCALE, (Float)this.field_6011.method_12789(DATA_SCALE));
        serializer.write(CodingKeys.TEXTURE, (EntityTextureDescriptor)this.field_6011.method_12789(DATA_TEXTURE));
        serializer.write(CodingKeys.TEXTURE_MODEL, (EntityTextureDescriptor.Model)((Object)this.field_6011.method_12789(DATA_TEXTURE_MODEL)));
        serializer.write(CodingKeys.POSE, this.saveCustomPose());
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.field_6011.method_12778(DATA_IS_CHILD, (Object)serializer.read(CodingKeys.IS_SMALL));
        this.field_6011.method_12778(DATA_IS_FLYING, (Object)serializer.read(CodingKeys.IS_FLYING));
        this.field_6011.method_12778(DATA_IS_GHOST, (Object)serializer.read(CodingKeys.IS_GHOST));
        this.field_6011.method_12778(DATA_IS_VISIBLE, (Object)serializer.read(CodingKeys.IS_VISIBLE));
        this.field_6011.method_12778(DATA_EXTRA_RENDERER, (Object)serializer.read(CodingKeys.EXTRA_RENDER));
        this.field_6011.method_12778(DATA_NO_GRAVITY, (Object)serializer.read(CodingKeys.NO_GRAVITY));
        this.field_6011.method_12778(DATA_SCALE, (Object)serializer.read(CodingKeys.SCALE));
        this.field_6011.method_12778(DATA_TEXTURE, (Object)serializer.read(CodingKeys.TEXTURE));
        this.field_6011.method_12778(DATA_TEXTURE_MODEL, (Object)serializer.read(CodingKeys.TEXTURE_MODEL));
        this.readCustomPose(serializer.read(CodingKeys.POSE));
        this.method_18382();
        this.refreshPhysics();
    }

    public void method_5674(class_2940<?> dataParameter) {
        if (DATA_IS_CHILD.equals(dataParameter)) {
            this.method_18382();
        }
        if (DATA_SCALE.equals(dataParameter)) {
            this.method_18382();
        }
        if (DATA_NO_GRAVITY.equals(dataParameter)) {
            this.refreshPhysics();
        }
        super.method_5674(dataParameter);
    }

    public boolean isModelVisible() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_VISIBLE);
    }

    public void setModelVisible(boolean value) {
        this.field_6011.method_12778(DATA_IS_VISIBLE, (Object)value);
    }

    public float method_17825() {
        return ((Float)this.field_6011.method_12789(DATA_SCALE)).floatValue();
    }

    public boolean method_6914() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_CHILD);
    }

    public boolean method_5740() {
        return (Boolean)this.field_6011.method_12789(DATA_NO_GRAVITY);
    }

    public void method_5875(boolean bl) {
        this.field_6011.method_12778(DATA_NO_GRAVITY, (Object)bl);
    }

    public boolean isFakeFlying() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_FLYING);
    }

    public boolean method_30948() {
        return this.method_5805() && (Boolean)this.field_6011.method_12789(DATA_IS_GHOST) == false;
    }

    @Override
    public class_4048 getDefaultDimensions(class_4050 pose) {
        if (this.method_6912()) {
            return MARKER_DIMENSIONS;
        }
        class_4048 entitySize = STANDING_DIMENSIONS;
        if (this.method_6109()) {
            entitySize = BABY_DIMENSIONS;
        }
        return entitySize;
    }

    @Override
    public class_1799 getCustomPickResult(class_239 target) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.MANNEQUIN.get());
        if (EnvironmentExecutorIO.hasControlDown()) {
            class_2487 entityTag = new class_2487();
            entityTag.method_10582("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            this.method_5652(entityTag);
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
        }
        return itemStack;
    }

    public void method_5636(float f) {
        super.method_5636(f);
        this.method_36456(f);
        this.field_6283 = f;
    }

    public void method_5814(double d, double e, double f) {
        super.method_5814(d, e, f);
        this.boundingBoxForCulling = null;
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.isDropEquipment = false;
        boolean flag = this.method_5805();
        boolean flag1 = super.method_5643(source, amount);
        class_1937 level = PropertyProvider.getLevel((class_1297)this);
        if (!this.isDropEquipment && flag != this.method_5805() && level instanceof class_3218) {
            this.brokenByAnything((class_3218)level, source);
        }
        return flag1;
    }

    public class_1269 method_5664(class_1657 player, class_243 pos, class_1268 hand) {
        if (this.method_6912()) {
            return class_1269.field_5811;
        }
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574((class_1792)ModItems.MANNEQUIN_TOOL.get())) {
            return class_1269.field_5811;
        }
        if (itemStack.method_31574(class_1802.field_8448)) {
            return itemStack.method_7920(player, (class_1309)this, hand);
        }
        if (player.method_21823()) {
            if (EnvironmentExecutorIO.hasControlDown()) {
                return super.method_5664(player, pos, hand);
            }
            double ry = OpenMath.getAngleDegrees(player.method_23317(), player.method_23321(), this.method_23317(), this.method_23321()) + 90.0;
            class_2379 rotations = this.method_6923();
            float yRot = this.method_36454();
            this.method_6927(new class_2379(rotations.method_10256(), (float)ry - yRot, rotations.method_10258()));
            return class_1269.method_29236((boolean)PropertyProvider.getLevel((class_1297)this).method_8608());
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((class_1297)this);
        if (wardrobe != null && wardrobe.isEditable(player)) {
            ((IMenuType)ModMenuTypes.WARDROBE.get()).openMenu(player, wardrobe);
            return class_1269.method_29236((boolean)PropertyProvider.getLevel((class_1297)this).method_8608());
        }
        return class_1269.field_5811;
    }

    @Override
    public void brokenByPlayer(class_3218 serverLevel, class_1282 source) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!player.method_31549().field_7477) {
                EntityData entityData = new EntityData();
                entityData.setScale(this.method_17825());
                entityData.setTexture(this.getTextureDescriptor());
                class_2248.method_9577((class_1937)PropertyProvider.getLevel((class_1297)this), (class_2338)this.method_24515(), (class_1799)entityData.itemStack());
            }
        }
        this.brokenByAnything(serverLevel, source);
    }

    protected void method_16078() {
        super.method_16078();
        this.isDropEquipment = true;
        SkinWardrobe wardrobe = SkinWardrobe.of((class_1297)this);
        if (wardrobe != null) {
            wardrobe.dropAll(arg_0 -> ((MannequinEntity)this).method_5775(arg_0));
        }
    }

    protected void refreshPhysics() {
        this.field_5960 = !this.hasPhysics();
    }

    protected boolean hasPhysics() {
        return !this.method_6912() && !this.method_5740();
    }

    @Environment(value=EnvType.CLIENT)
    public class_238 method_5830() {
        if (this.boundingBoxForCulling != null) {
            return this.boundingBoxForCulling;
        }
        float f = this.method_17825();
        this.boundingBoxForCulling = this.method_5829().method_1009((double)(f * 3.0f), (double)(f * 2.0f), (double)(f * 2.5f));
        return this.boundingBoxForCulling;
    }

    public EntityTextureDescriptor getTextureDescriptor() {
        return (EntityTextureDescriptor)this.field_6011.method_12789(DATA_TEXTURE);
    }

    public void setTextureDescriptor(EntityTextureDescriptor newValue) {
        this.field_6011.method_12778(DATA_TEXTURE, (Object)newValue);
    }

    public EntityTextureDescriptor.Model getTextureModel() {
        return (EntityTextureDescriptor.Model)((Object)this.field_6011.method_12789(DATA_TEXTURE_MODEL));
    }

    public void setTextureModel(EntityTextureDescriptor.Model newValue) {
        this.field_6011.method_12778(DATA_TEXTURE_MODEL, (Object)newValue);
    }

    public boolean isExtraRenderer() {
        return (Boolean)this.field_6011.method_12789(DATA_EXTRA_RENDERER);
    }

    public void setExtraRenderer(boolean value) {
        this.field_6011.method_12778(DATA_EXTRA_RENDERER, (Object)value);
    }

    public class_1263 getInventory() {
        return new class_1277(new class_1799[]{this.method_6047(), this.method_6079()}){

            public void method_5447(int index, class_1799 itemStack) {
                super.method_5447(index, itemStack);
                MannequinEntity.this.method_5673(class_1304.values()[index], itemStack);
            }
        };
    }

    public class_2487 saveCustomPose() {
        TagSerializer serializer = new TagSerializer();
        serializer.write(CodingKeys.POSE_HEAD, (class_2379)this.field_6011.method_12789(field_7123));
        serializer.write(CodingKeys.POSE_BODY, (class_2379)this.field_6011.method_12789(field_7122));
        serializer.write(CodingKeys.POSE_LEFT_ARM, (class_2379)this.field_6011.method_12789(field_7116));
        serializer.write(CodingKeys.POSE_RIGHT_ARM, (class_2379)this.field_6011.method_12789(field_7105));
        serializer.write(CodingKeys.POSE_LEFT_LEG, (class_2379)this.field_6011.method_12789(field_7127));
        serializer.write(CodingKeys.POSE_RIGHT_LEG, (class_2379)this.field_6011.method_12789(field_7125));
        return serializer.tag();
    }

    public void readCustomPose(class_2487 tag) {
        TagSerializer serializer = new TagSerializer(tag);
        this.method_6919(serializer.read(CodingKeys.POSE_HEAD));
        this.method_6927(serializer.read(CodingKeys.POSE_BODY));
        this.method_6910(serializer.read(CodingKeys.POSE_LEFT_ARM));
        this.method_6925(serializer.read(CodingKeys.POSE_RIGHT_ARM));
        this.method_6909(serializer.read(CodingKeys.POSE_LEFT_LEG));
        this.method_6926(serializer.read(CodingKeys.POSE_RIGHT_LEG));
    }

    public void saveMannequinToolData(class_2487 entityTag) {
        this.serialize(new TagSerializer(entityTag));
    }

    public void readMannequinToolData(class_2487 entityTag, class_1799 itemStack) {
        class_2520 oldValue;
        class_2487 newEntityTag = new class_2487();
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_OPTION).booleanValue()) {
            newEntityTag.method_10543(entityTag);
            newEntityTag.method_10551(CodingKeys.SCALE.name());
            newEntityTag.method_10551(CodingKeys.POSE.name());
            newEntityTag.method_10551(CodingKeys.TEXTURE.name());
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_SCALE).booleanValue() && (oldValue = entityTag.method_10580(CodingKeys.SCALE.name())) != null) {
            newEntityTag.method_10566(CodingKeys.SCALE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_ROTATION).booleanValue()) {
            oldValue = OptionalAPI.getOptionalCompound(entityTag, CodingKeys.POSE.name()).orElseGet(class_2487::new);
            if (ToolAPI.get(itemStack, MannequinToolOptions.MIRROR_MODE).booleanValue() && !oldValue.method_33133()) {
                TagSerializer poseSerializer = new TagSerializer(oldValue.method_10553());
                poseSerializer.write(CodingKeys.POSE_HEAD, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_HEAD)));
                poseSerializer.write(CodingKeys.POSE_BODY, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_BODY)));
                poseSerializer.write(CodingKeys.POSE_LEFT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_ARM)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_ARM, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_ARM)));
                poseSerializer.write(CodingKeys.POSE_LEFT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_LEFT_LEG)));
                poseSerializer.write(CodingKeys.POSE_RIGHT_LEG, EntityData.mirror(poseSerializer.read(CodingKeys.POSE_RIGHT_LEG)));
                oldValue = poseSerializer.tag();
            }
            newEntityTag.method_10566(CodingKeys.POSE.name(), oldValue);
        }
        if (ToolAPI.get(itemStack, MannequinToolOptions.CHANGE_TEXTURE).booleanValue() && (oldValue = entityTag.method_10580(CodingKeys.TEXTURE.name())) != null) {
            newEntityTag.method_10566(CodingKeys.TEXTURE.name(), oldValue);
        }
        this.deserialize(new TagSerializer(newEntityTag));
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Boolean> IS_SMALL = IDataSerializerKey.create("Small", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_FLYING = IDataSerializerKey.create("Flying", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_GHOST = IDataSerializerKey.create("Ghost", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Boolean> IS_VISIBLE = IDataSerializerKey.create("ModelVisible", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> EXTRA_RENDER = IDataSerializerKey.create("ExtraRender", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> NO_GRAVITY = IDataSerializerKey.create("NoGravity", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Float> SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<EntityTextureDescriptor> TEXTURE = IDataSerializerKey.create("Texture", EntityTextureDescriptor.CODEC, EntityTextureDescriptor.EMPTY);
        public static final IDataSerializerKey<EntityTextureDescriptor.Model> TEXTURE_MODEL = IDataSerializerKey.create("TextureModel", DataSerializers.ENTITY_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
        public static final IDataSerializerKey<class_2487> POSE = IDataSerializerKey.create("Pose", IDataCodec.COMPOUND_TAG, new class_2487());
        public static final IDataSerializerKey<class_2379> POSE_HEAD = IDataSerializerKey.create("Head", EntityData.ROTATIONS_CODEC, DEFAULT_HEAD_POSE);
        public static final IDataSerializerKey<class_2379> POSE_BODY = IDataSerializerKey.create("Body", EntityData.ROTATIONS_CODEC, DEFAULT_BODY_POSE);
        public static final IDataSerializerKey<class_2379> POSE_LEFT_ARM = IDataSerializerKey.create("LeftArm", EntityData.ROTATIONS_CODEC, DEFAULT_LEFT_ARM_POSE);
        public static final IDataSerializerKey<class_2379> POSE_RIGHT_ARM = IDataSerializerKey.create("RightArm", EntityData.ROTATIONS_CODEC, DEFAULT_RIGHT_ARM_POSE);
        public static final IDataSerializerKey<class_2379> POSE_LEFT_LEG = IDataSerializerKey.create("LeftLeg", EntityData.ROTATIONS_CODEC, DEFAULT_LEFT_LEG_POSE);
        public static final IDataSerializerKey<class_2379> POSE_RIGHT_LEG = IDataSerializerKey.create("RightLeg", EntityData.ROTATIONS_CODEC, DEFAULT_RIGHT_LEG_POSE);

        private CodingKeys() {
        }
    }

    public static class EntityData {
        private static final IDataCodec<class_2379> ROTATIONS_CODEC = IDataCodec.FLOAT.listOf().xmap(it -> new class_2379(((Float)it.get(0)).floatValue(), ((Float)it.get(1)).floatValue(), ((Float)it.get(2)).floatValue()), it -> Collections.newList(Float.valueOf(it.method_10256()), Float.valueOf(it.method_10257()), Float.valueOf(it.method_10258())));
        private final TagSerializer serializer;

        public EntityData() {
            this.serializer = new TagSerializer();
        }

        public EntityData(class_2487 tag) {
            this.serializer = new TagSerializer(tag);
        }

        private static class_2379 mirror(class_2379 rot) {
            return new class_2379(rot.method_10256(), -rot.method_10257(), -rot.method_10258());
        }

        public void setScale(float scale) {
            this.serializer.write(CodingKeys.SCALE, Float.valueOf(scale));
        }

        public float scale() {
            return this.serializer.read(CodingKeys.SCALE).floatValue();
        }

        public void setTexture(EntityTextureDescriptor texture) {
            this.serializer.write(CodingKeys.TEXTURE, texture);
        }

        public EntityTextureDescriptor texture() {
            return this.serializer.read(CodingKeys.TEXTURE);
        }

        public boolean isSmall() {
            return this.serializer.read(CodingKeys.IS_SMALL);
        }

        public class_2487 entityTag() {
            class_2487 entityTag = this.serializer.tag().method_10553();
            if (!entityTag.method_33133()) {
                entityTag.method_10582("id", ModEntityTypes.MANNEQUIN.registryName().toString());
            }
            return entityTag;
        }

        public class_1799 itemStack() {
            class_1799 itemStack = new class_1799((class_1935)ModItems.MANNEQUIN.get());
            class_2487 entityTag = this.entityTag();
            if (!entityTag.method_33133()) {
                ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get(), entityTag);
            }
            return itemStack;
        }
    }
}

