/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Compiler;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.SyntaxException;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.ObjectBinding;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.PrimaryBinding;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.holder.LambdaVariableHolder;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;

public class MolangVirtualMachine {
    private static final Map<String, ObjectBinding> REGISTERED_BINDINGS = new ConcurrentHashMap<String, ObjectBinding>();
    protected final Compiler compiler;

    public MolangVirtualMachine() {
        this(Collections.emptyMap());
    }

    public MolangVirtualMachine(Map<String, ObjectBinding> bindings) {
        HashMap<String, ObjectBinding> mergedBindings = new HashMap<String, ObjectBinding>(REGISTERED_BINDINGS);
        mergedBindings.putAll(bindings);
        this.compiler = new Compiler(new PrimaryBinding(mergedBindings));
    }

    public static void register(String name, ObjectBinding binding) {
        REGISTERED_BINDINGS.put(name, binding);
    }

    public Expression compile(String source) throws SyntaxException {
        Expression expr = this.compiler.compile(source);
        if (ModConfig.Client.enableMolangDebug && !(expr instanceof Constant)) {
            ModLog.debug("source: {}", source);
            ModLog.debug("optimize: {}", expr);
        }
        return expr;
    }

    public void beginVariableCaching() {
        LambdaVariableHolder.push();
    }

    public void endVariableCaching() {
        LambdaVariableHolder.pop();
    }
}

