/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.EquipmentItemProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix1621;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EffectSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.ItemSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.LivingEntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EffectSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ItemSelectorImpl;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class LivingEntitySelectorImpl<T extends class_1309>
extends EntitySelectorImpl<T>
implements LivingEntitySelector {
    private static final Map<String, Optional<OpenEquipmentSlot>> NAMED_SLOTS = new ConcurrentHashMap<String, Optional<OpenEquipmentSlot>>();
    private static final Map<String, OpenEquipmentSlot> FIXED_SLOTS = Collections.immutableMap(it -> {
        it.put((Object)"chest", (Object)OpenEquipmentSlot.CHEST);
        it.put((Object)"feet", (Object)OpenEquipmentSlot.FEET);
        it.put((Object)"head", (Object)OpenEquipmentSlot.HEAD);
        it.put((Object)"legs", (Object)OpenEquipmentSlot.LEGS);
        it.put((Object)"mainhand", (Object)OpenEquipmentSlot.MAINHAND);
        it.put((Object)"offhand", (Object)OpenEquipmentSlot.OFFHAND);
        it.put((Object)"body", (Object)OpenEquipmentSlot.BODY);
    });
    private final ItemSelectorImpl itemSelector = new ItemSelectorImpl();
    private final EffectSelectorImpl effectSelector = new EffectSelectorImpl();

    @Override
    public LivingEntitySelectorImpl<T> apply(T entity, ContextSelectorImpl context) {
        super.apply(entity, context);
        return this;
    }

    @Override
    public double bodyYaw() {
        return MathHelper.lerp(this.partialTick(), ((class_1309)this.entity).field_6004, ((class_1309)this.entity).method_36455());
    }

    @Override
    public double bodyPitch() {
        return MathHelper.wrapDegrees(MathHelper.lerp(this.partialTick(), ((class_1309)this.entity).field_5982, ((class_1309)this.entity).method_36454()));
    }

    @Override
    public double health() {
        return ((class_1309)this.entity).method_6032();
    }

    @Override
    public double maxHealth() {
        return ((class_1309)this.entity).method_6063();
    }

    @Override
    public double armorValue() {
        return ((class_1309)this.entity).method_6096();
    }

    @Override
    public double hurtTime() {
        return ((class_1309)this.entity).field_6235;
    }

    @Override
    public boolean isDeadOrDying() {
        return ((class_1309)this.entity).method_29504();
    }

    @Override
    public boolean isEating() {
        return ((class_1309)this.entity).method_6030().method_7976() == class_1839.field_8950;
    }

    @Override
    public boolean isSleeping() {
        return ((class_1309)this.entity).method_6113();
    }

    @Override
    public boolean isUsingItem() {
        return ((class_1309)this.entity).method_6115();
    }

    @Override
    public boolean isAutoSpinAttack() {
        return ((class_1309)this.entity).method_6123();
    }

    @Override
    public boolean isOnClimbable() {
        return ((class_1309)this.entity).method_6101();
    }

    @Override
    public double usingItemDuration() {
        return (double)((class_1309)this.entity).method_6048() / 20.0;
    }

    @Override
    public double usingItemMaxDuration() {
        class_1799 item = ((class_1309)this.entity).method_6030();
        if (!item.method_7960()) {
            return Fix1621.getUseDuration(item, (class_1309)this.entity) / 20.0;
        }
        return 0.0;
    }

    @Override
    public double usingItemRemainingDuration() {
        return (double)((class_1309)this.entity).method_6014() / 20.0;
    }

    @Override
    public int arrowCount() {
        return ((class_1309)this.entity).method_6022();
    }

    @Override
    public int stingerCount() {
        return ((class_1309)this.entity).method_21753();
    }

    @Override
    public double attributeValueByName(String name) {
        return AbstractRegistryManager.getAttribute((class_1309)this.entity, name);
    }

    @Override
    @Nullable
    public EffectSelector effectByName(String name) {
        class_1293 effect = AbstractRegistryManager.getEffect((class_1309)this.entity, name);
        if (effect != null) {
            return this.effectSelector.apply(effect);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemSelector equippedItemBySlot(String name) {
        Optional slot = NAMED_SLOTS.computeIfAbsent(name, LivingEntitySelectorImpl::findSlot);
        class_1799 itemStack = slot.map(it -> EquipmentItemProvider.getItemBySlot((class_1309)this.entity, it)).orElse(class_1799.field_8037);
        if (!itemStack.method_7960()) {
            return this.itemSelector.apply(itemStack);
        }
        return null;
    }

    @Override
    public int equipmentCount() {
        int count = 0;
        for (OpenEquipmentSlot slot : OpenEquipmentSlot.values()) {
            class_1799 stack;
            if (slot == OpenEquipmentSlot.MAINHAND || slot == OpenEquipmentSlot.OFFHAND || (stack = EquipmentItemProvider.getItemBySlot((class_1309)this.entity, slot)).method_7960()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int lastClimbableFacing() {
        class_1937 level = PropertyProvider.getLevel(this.entity);
        if (level == null) {
            return 0;
        }
        Optional climbablePos = ((class_1309)this.entity).method_24832();
        if (!climbablePos.isPresent()) {
            return 0;
        }
        class_2680 blockState = level.method_8320((class_2338)climbablePos.get());
        Optional facing = blockState.method_28500((class_2769)class_2383.field_11177);
        return facing.map(class_2350::method_10161).orElse(0);
    }

    private static Optional<OpenEquipmentSlot> findSlot(String name) {
        return Optional.ofNullable(FIXED_SLOTS.get(name.toLowerCase()));
    }
}

