/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class ParticleDynamicMotion
extends SkinParticleComponent {
    private final OpenPrimitive motionAccelerationX;
    private final OpenPrimitive motionAccelerationY;
    private final OpenPrimitive motionAccelerationZ;
    private final OpenPrimitive motionDragCoefficient;
    private final OpenPrimitive rotationAcceleration;
    private final OpenPrimitive rotationDragCoefficient;

    public ParticleDynamicMotion(OpenPrimitive motionAccelerationX, OpenPrimitive motionAccelerationY, OpenPrimitive motionAccelerationZ, OpenPrimitive motionDragCoefficient, OpenPrimitive rotationAcceleration, OpenPrimitive rotationDragCoefficient) {
        this.motionAccelerationX = motionAccelerationX;
        this.motionAccelerationY = motionAccelerationY;
        this.motionAccelerationZ = motionAccelerationZ;
        this.motionDragCoefficient = motionDragCoefficient;
        this.rotationAcceleration = rotationAcceleration;
        this.rotationDragCoefficient = rotationDragCoefficient;
    }

    public ParticleDynamicMotion(IInputStream stream) throws IOException {
        this.motionAccelerationX = stream.readPrimitiveObject();
        this.motionAccelerationY = stream.readPrimitiveObject();
        this.motionAccelerationZ = stream.readPrimitiveObject();
        this.motionDragCoefficient = stream.readPrimitiveObject();
        this.rotationAcceleration = stream.readPrimitiveObject();
        this.rotationDragCoefficient = stream.readPrimitiveObject();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.motionAccelerationX);
        stream.writePrimitiveObject(this.motionAccelerationY);
        stream.writePrimitiveObject(this.motionAccelerationZ);
        stream.writePrimitiveObject(this.motionDragCoefficient);
        stream.writePrimitiveObject(this.rotationAcceleration);
        stream.writePrimitiveObject(this.rotationDragCoefficient);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression motionAccelerationX = builder.compile(this.motionAccelerationX, 0.0);
        Expression motionAccelerationY = builder.compile(this.motionAccelerationY, 0.0);
        Expression motionAccelerationZ = builder.compile(this.motionAccelerationZ, 0.0);
        Expression motionDragCoefficient = builder.compile(this.motionDragCoefficient, 0.0);
        Expression rotationAcceleration = builder.compile(this.rotationAcceleration, 0.0);
        Expression rotationDragCoefficient = builder.compile(this.rotationDragCoefficient, 0.0);
        builder.updateParticle((emitter, particle, context) -> {
            double tx = motionAccelerationX.compute(context);
            double ty = motionAccelerationY.compute(context);
            double tz = motionAccelerationZ.compute(context);
            double td = motionDragCoefficient.compute(context);
            double ra = rotationAcceleration.compute(context);
            double rd = rotationDragCoefficient.compute(context);
        });
    }
}

