/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.core.IRegistryEntry;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;

public class SkinDocumentType
implements IRegistryEntry {
    private static final Map<SkinPartType, Collection<SkinPartType>> LINKED_PARTS = Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_CHEST, Collections.newList(SkinPartTypes.BIPPED_TORSO));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, Collections.newList(SkinPartTypes.BIPPED_LEFT_HAND));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, Collections.newList(SkinPartTypes.BIPPED_RIGHT_HAND));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, Collections.newList(SkinPartTypes.BIPPED_LEFT_LEG));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, Collections.newList(SkinPartTypes.BIPPED_RIGHT_LEG));
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_WING, Collections.newList(SkinPartTypes.BIPPED_RIGHT_PHALANX));
        it.put((Object)SkinPartTypes.BIPPED_LEFT_WING, Collections.newList(SkinPartTypes.BIPPED_LEFT_PHALANX));
        it.put((Object)SkinPartTypes.ITEM_SHIELD, Collections.newList(SkinPartTypes.ITEM_SHIELD1));
        it.put((Object)SkinPartTypes.ITEM_TRIDENT, Collections.newList(SkinPartTypes.ITEM_TRIDENT1));
        it.put((Object)SkinPartTypes.ITEM_FISHING_ROD, Collections.newList(SkinPartTypes.ITEM_FISHING_ROD1));
    });
    private static final Set<SkinPartType> DISABLED_PARTS = Collections.immutableSet(builder -> builder.add((Object)SkinPartTypes.BLOCK_MULTI));
    private final String category;
    private final SkinType skinType;
    private final ArrayList<SkinPartType> skinPartTypes;
    private OpenResourceLocation registryName;

    public SkinDocumentType(String category, SkinType type) {
        this.category = category;
        this.skinType = type;
        this.skinPartTypes = this.generatePartTypes(type);
    }

    public String name() {
        return this.registryName.toString();
    }

    public String category() {
        return this.category;
    }

    public SkinType skinType() {
        return this.skinType;
    }

    public List<? extends SkinPartType> skinPartTypes() {
        return this.skinPartTypes;
    }

    public void setRegistryName(OpenResourceLocation registryName) {
        this.registryName = registryName;
    }

    @Override
    public OpenResourceLocation registryName() {
        return this.registryName;
    }

    public String toString() {
        return Objects.toString(this, "name", this.category, "id", this.registryName);
    }

    private ArrayList<SkinPartType> generatePartTypes(SkinType type) {
        ArrayList<SkinPartType> partTypes = new ArrayList<SkinPartType>();
        for (SkinPartType skinPartType : type.parts()) {
            if (DISABLED_PARTS.contains(skinPartType)) continue;
            Collection<SkinPartType> linkedParts = LINKED_PARTS.get(skinPartType);
            partTypes.add(skinPartType);
            if (linkedParts == null) continue;
            partTypes.addAll(linkedParts);
        }
        return partTypes;
    }
}

