/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.io;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public interface IODataObject {
    public static IODataObject of(JsonElement element) {
        return () -> element;
    }

    default public Type type() {
        JsonElement object = this.jsonValue();
        if (object == null || object.isJsonNull()) {
            return Type.NULL;
        }
        if (object.isJsonObject()) {
            return Type.DICTIONARY;
        }
        if (object.isJsonArray()) {
            return Type.ARRAY;
        }
        if (object.isJsonPrimitive()) {
            JsonPrimitive primitive = object.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return Type.NUMBER;
            }
            if (primitive.isBoolean()) {
                return Type.BOOLEAN;
            }
            if (primitive.isString()) {
                return Type.STRING;
            }
        }
        return Type.NULL;
    }

    default public void add(IODataObject value) {
        if (this.type() == Type.ARRAY) {
            this.jsonValue().getAsJsonArray().add(value.jsonValue());
        }
    }

    default public IODataObject at(int index) {
        if (this.type() == Type.ARRAY) {
            return IODataObject.of(this.jsonValue().getAsJsonArray().get(index));
        }
        return IODataObject.of(null);
    }

    default public int size() {
        if (this.type() == Type.ARRAY) {
            return this.jsonValue().getAsJsonArray().size();
        }
        if (this.type() == Type.DICTIONARY) {
            return this.jsonValue().getAsJsonObject().size();
        }
        return 0;
    }

    default public void set(String key, IODataObject value) {
        if (this.type() == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().add(key, value.jsonValue());
        }
    }

    default public IODataObject get(String key) {
        if (this.type() == Type.DICTIONARY) {
            return IODataObject.of(this.jsonValue().getAsJsonObject().get(key));
        }
        return IODataObject.of(null);
    }

    default public boolean has(String key) {
        if (this.type() == Type.DICTIONARY) {
            return this.jsonValue().getAsJsonObject().has(key);
        }
        return false;
    }

    default public Collection<String> allKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.type() == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().entrySet().forEach(it -> keys.add((String)it.getKey()));
        }
        return keys;
    }

    default public Collection<IODataObject> allValues() {
        Type type = this.type();
        ArrayList<IODataObject> values = new ArrayList<IODataObject>();
        if (type == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().entrySet().forEach(it -> values.add(IODataObject.of((JsonElement)it.getValue())));
        }
        if (type == Type.ARRAY) {
            this.jsonValue().getAsJsonArray().forEach(val -> values.add(IODataObject.of(val)));
        }
        return values;
    }

    default public Collection<Pair<String, IODataObject>> entrySet() {
        ArrayList<Pair<String, IODataObject>> keys = new ArrayList<Pair<String, IODataObject>>();
        if (this.type() == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().entrySet().forEach(it -> keys.add(Pair.of((Object)((String)it.getKey()), (Object)IODataObject.of((JsonElement)it.getValue()))));
        }
        return keys;
    }

    default public <T> ArrayList<T> collect(Function<IODataObject, ? extends T> mapper) {
        Collection<IODataObject> values = this.allValues();
        ArrayList<T> results = new ArrayList<T>(values.size());
        for (IODataObject value : values) {
            results.add(mapper.apply(value));
        }
        return results;
    }

    default public boolean boolValue() {
        return switch (this.type().ordinal()) {
            case 2, 3 -> {
                if (this.numberValue().intValue() != 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> this.jsonValue().getAsBoolean();
            default -> false;
        };
    }

    default public Number numberValue() {
        return switch (this.type().ordinal()) {
            case 2, 3 -> this.jsonValue().getAsNumber();
            case 1 -> this.jsonValue().getAsBoolean() ? 1 : 0;
            default -> 0;
        };
    }

    default public int intValue() {
        return this.numberValue().intValue();
    }

    default public float floatValue() {
        return this.numberValue().floatValue();
    }

    default public String stringValue() {
        return switch (this.type().ordinal()) {
            case 1, 2, 3 -> this.jsonValue().getAsString();
            default -> "";
        };
    }

    default public boolean isNull() {
        return this.type() == Type.NULL;
    }

    default public void ifPresent(Consumer<IODataObject> consumer) {
        if (this.type() != Type.NULL) {
            consumer.accept(this);
        }
    }

    public JsonElement jsonValue();

    public static enum Type {
        NULL,
        BOOLEAN,
        NUMBER,
        STRING,
        ARRAY,
        DICTIONARY;

    }
}

