/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;

public class ChunkPaintData {
    public SkinPaintData readFromStream(ChunkDataInputStream stream) throws IOException {
        int height;
        int width;
        int options = stream.readInt();
        SkinPaintData paintData = this._createPaintData(options, width = stream.readVarInt(), height = stream.readVarInt());
        if (paintData == null) {
            return null;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                paintData.setColor(x, y, stream.readInt());
            }
        }
        return paintData;
    }

    public void writeToStream(SkinPaintData paintData, ChunkDataOutputStream stream) throws IOException {
        int options = 0;
        int width = paintData.width();
        int height = paintData.height();
        stream.writeInt(options);
        stream.writeVarInt(width);
        stream.writeVarInt(height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                stream.writeInt(paintData.getColor(x, y));
            }
        }
    }

    private SkinPaintData _createPaintData(int options, int width, int height) {
        if (width == 64 && height == 32) {
            return SkinPaintData.v1();
        }
        if (width == 64 && height == 64) {
            return SkinPaintData.v2(false);
        }
        return null;
    }
}

