/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import java.util.HashMap;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class SkinPaintData {
    public static final int TEXTURE_OLD_WIDTH = 64;
    public static final int TEXTURE_OLD_HEIGHT = 32;
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    private final int width;
    private final int height;
    private final int[] bytes;

    public SkinPaintData(int width, int height) {
        this(width, height, new int[width * height]);
    }

    public SkinPaintData(int width, int height, int[] bytes) {
        this.width = width;
        this.height = height;
        this.bytes = bytes;
    }

    public static SkinPaintData v1() {
        return new SkinPaintData(64, 32);
    }

    public static SkinPaintData v2(boolean slim) {
        SkinPaintData paintData = new SkinPaintData(64, 64);
        paintData.setFlag(0, slim);
        return paintData;
    }

    public SkinPaintData clone() {
        SkinPaintData paintData = new SkinPaintData(this.width, this.height);
        System.arraycopy(this.bytes, 0, paintData.bytes, 0, this.bytes.length);
        return paintData;
    }

    public void copyFrom(SkinPaintData other) {
        if (this.width != other.width()) {
            return;
        }
        if (this.height == other.height() && this.slim() == other.slim()) {
            System.arraycopy(other.bytes(), 0, this.bytes, 0, this.bytes.length);
            return;
        }
        EntityTextureModel source = EntityTextureModel.of(other.width(), other.height(), other.slim());
        EntityTextureModel destination = EntityTextureModel.of(this.width(), this.height(), this.slim());
        source.forEach((partType, sourceBox) -> {
            EntityTextureModel.Box destinationBox = destination.get((SkinPartType)partType);
            if (destinationBox != null) {
                other.copyTo((EntityTextureModel.Box)sourceBox, this, destinationBox, false);
            }
        });
    }

    public void copyTo(EntityTextureModel.Box srcBox, SkinPaintData destData, EntityTextureModel.Box destBox, boolean isMirrorX) {
        int srcX = srcBox.bounds().x();
        int srcY = srcBox.bounds().y();
        int srcZ = srcBox.bounds().z();
        int srcWidth = srcBox.bounds().width() - 1;
        int srcHeight = srcBox.bounds().height() - 1;
        int srcDepth = srcBox.bounds().depth() - 1;
        int destX = destBox.bounds().x();
        int destY = destBox.bounds().y();
        int destZ = destBox.bounds().z();
        int destWidth = destBox.bounds().width() - 1;
        int destHeight = destBox.bounds().height() - 1;
        int destDepth = destBox.bounds().depth() - 1;
        HashMap<OpenVector2i, Integer> colors = new HashMap<OpenVector2i, Integer>();
        srcBox.forEach((texturePos, x, y, z, dir) -> {
            int iz;
            int iy;
            int ix;
            OpenVector2i newTexturePose;
            float px = (float)(x - srcX) / (float)srcWidth;
            float py = (float)(y - srcY) / (float)srcHeight;
            float pz = (float)(z - srcZ) / (float)srcDepth;
            if (isMirrorX) {
                px = 1.0f - px;
                if (dir.axis() == OpenDirection.Axis.X) {
                    dir = dir.opposite();
                }
            }
            if ((newTexturePose = destBox.get((ix = OpenMath.roundi(px * (float)destWidth)) + destX, (iy = OpenMath.roundi(py * (float)destHeight)) + destY, (iz = OpenMath.roundi(pz * (float)destDepth)) + destZ, dir)) == null) {
                return;
            }
            int color = this.getColor(texturePos);
            if (SkinPaintColor.isOpaque(color)) {
                colors.put(newTexturePose, color);
            }
        });
        colors.forEach(destData::setColor);
    }

    public int getColor(OpenVector2i point) {
        return this.getColor(point.x(), point.y());
    }

    public void setColor(OpenVector2i point, int color) {
        this.setColor(point.x(), point.y(), color);
    }

    public int getColor(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        return this.bytes[x + y * this.width];
    }

    public void setColor(int x, int y, SkinPaintColor paintColor) {
        this.setColor(x, y, paintColor.rawValue());
    }

    public void setColor(int x, int y, int color) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.bytes[x + y * this.width] = color;
    }

    public int version() {
        if (this.width == 64 && this.height == 32) {
            return 1;
        }
        if (this.width == 64 && this.height == 64) {
            return 2;
        }
        return 0;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int[] bytes() {
        return this.bytes;
    }

    public boolean slim() {
        return this.getFlag(0);
    }

    private void setFlag(int bit, boolean value) {
        this.bytes[0] = value ? this.bytes[0] | 1 << bit : this.bytes[0] & ~(1 << bit);
    }

    private boolean getFlag(int bit) {
        return (this.bytes[0] & 1 << bit) != 0;
    }
}

