/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractSavedData;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.storage.DimensionDataStorage.DataProvider;
import moe.plushie.armourers_workshop.core.utils.OpenClock;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ModContext
extends AbstractSavedData {
    private static final OpenClock CLOCK = new OpenClock();
    private static ModContext CURRENT;
    private UUID t0;
    private UUID t1;
    private byte[] x0;
    private byte[] x1;

    public ModContext() {
        this.random();
        this.method_80();
    }

    public static void init(MinecraftServer server) {
        CURRENT = DataProvider.computeIfAbsent(server.method_30002().method_17983(), ModContext::new, 0, "ArmourersWorkshop");
    }

    public static void init(UUID t0, UUID t1) {
        CURRENT = new ModContext();
        CURRENT.apply(t0, t1);
    }

    public static void reset() {
        CURRENT = null;
    }

    public static UUID t0() {
        if (CURRENT != null) {
            return ModContext.CURRENT.t0;
        }
        return null;
    }

    public static UUID t1() {
        if (CURRENT != null) {
            return ModContext.CURRENT.t1;
        }
        return null;
    }

    public static UUID t2(UUID p) {
        return ModContext.md5(Objects.requireNonNull(ModContext.t0()), p);
    }

    public static UUID t3(UUID p) {
        return ModContext.md5(Objects.requireNonNull(ModContext.t1()), p);
    }

    public static byte[] x0() {
        if (CURRENT != null) {
            return ModContext.CURRENT.x0;
        }
        return null;
    }

    public static byte[] x1() {
        if (CURRENT != null) {
            return ModContext.CURRENT.x1;
        }
        return null;
    }

    public static long time() {
        return CLOCK.time();
    }

    @NotNull
    private static UUID md5(UUID v1, UUID v2) {
        int v0 = 20220616;
        ByteBuffer buffer0 = ByteBuffer.allocate(64);
        buffer0.putLong(v0 + -527525385);
        buffer0.putLong(v1.getLeastSignificantBits());
        buffer0.putLong(v0 + -1629023019);
        buffer0.putLong(v2.getMostSignificantBits());
        buffer0.putLong(v0 + 1022817964);
        buffer0.putLong(v1.getLeastSignificantBits());
        buffer0.putLong(v0 + 1821159228);
        buffer0.putLong(v2.getLeastSignificantBits());
        return UUID.nameUUIDFromBytes(buffer0.array());
    }

    private void apply(UUID t0, UUID t1) {
        ModLog.debug("apply context", new Object[0]);
        this.t0 = t0;
        this.t1 = t1;
        this.x0 = null;
        this.x1 = null;
        if (t0 == null || t1 == null) {
            return;
        }
        try {
            int v0 = 20220616;
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteBuffer buffer0 = ByteBuffer.allocate(64);
            ByteBuffer buffer1 = ByteBuffer.allocate(192);
            buffer0.putLong(v0 + -527525385);
            buffer0.putLong(t0.getLeastSignificantBits());
            buffer0.putLong(v0 + -1629023019);
            buffer0.putLong(t0.getMostSignificantBits());
            buffer0.putLong(v0 + 1022817964);
            buffer0.putLong(t1.getLeastSignificantBits());
            buffer0.putLong(v0 + 1821159228);
            this.x0 = md.digest(buffer0.array());
            buffer1.putLong(v0 + -527525383);
            buffer1.putLong(t1.getMostSignificantBits());
            buffer1.putLong(t0.getLeastSignificantBits());
            buffer1.putLong(v0 + -1629023019);
            buffer1.put(this.x0);
            buffer1.putLong(v0 + 1022817964);
            buffer1.putLong(t1.getLeastSignificantBits());
            buffer1.putLong(t0.getMostSignificantBits());
            buffer1.putLong(v0 + 1821159228);
            this.x1 = md.digest(buffer1.array());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void random() {
        this.t0 = UUID.randomUUID();
        this.t1 = UUID.randomUUID();
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        CLOCK.setTime(serializer.read(CodingKeys.CLOCK));
        int count = 0;
        this.t0 = serializer.read(CodingKeys.T0);
        if (this.t0 != null) {
            ++count;
        }
        this.t1 = serializer.read(CodingKeys.T1);
        if (this.t1 != null) {
            ++count;
        }
        if (count != 2) {
            this.random();
        }
        this.apply(this.t0, this.t1);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.CLOCK, CLOCK.time());
        serializer.write(CodingKeys.T0, this.t0);
        serializer.write(CodingKeys.T1, this.t1);
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<UUID> T0 = IDataSerializerKey.create("t0", IDataCodec.UUID, null);
        public static final IDataSerializerKey<UUID> T1 = IDataSerializerKey.create("t1", IDataCodec.UUID, null);
        public static final IDataSerializerKey<Long> CLOCK = IDataSerializerKey.create("clock", IDataCodec.LONG, 0L);

        private CodingKeys() {
        }
    }
}

