/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Minecraft.ItemModelProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModel;
import moe.plushie.armourers_workshop.core.client.model.EmbeddedItemModels;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinLightSource;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientDynamicLightHandler<T> {
    private static class_1297 TICKING_ENTITY;

    public static void init() {
        ModConfig.Client.enableDynamicLightHandler = true;
    }

    public static void startTick(class_1297 entity) {
        TICKING_ENTITY = entity;
    }

    public static void endTick(class_1297 entity) {
        TICKING_ENTITY = null;
    }

    public static SkinLightSource getLightSource(class_1297 entity) {
        SkinLightSource lightSource;
        if (!ModConfig.enableDynamicLightHandler()) {
            return null;
        }
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && (lightSource = renderData.lightSource()).isEnabled()) {
            return lightSource;
        }
        return null;
    }

    public static SkinLightSource getLightSource(class_2586 entity) {
        SkinLightSource lightSource;
        if (!ModConfig.enableDynamicLightHandler()) {
            return null;
        }
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData != null && (lightSource = renderData.lightSource()).isEnabled()) {
            return lightSource;
        }
        return null;
    }

    public static SkinLightSource getLightSource(class_1799 itemStack, boolean submergedInWater) {
        BakedSkin bakedSkin;
        if (!ModConfig.enableDynamicLightHandler()) {
            return null;
        }
        EmbeddedItemModel itemModel = ClientDynamicLightHandler.getItemModel(itemStack);
        if (itemModel != null && (bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.INVENTORY.get(itemModel.sourceSkin()))) != null) {
            return bakedSkin.renderInfo().lightSource();
        }
        return null;
    }

    private static EmbeddedItemModel getItemModel(class_1799 itemStack) {
        class_1297 class_12972 = TICKING_ENTITY;
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            return ClientDynamicLightHandler.getItemModel(itemStack, PropertyProvider.getLevel((class_1297)entity), entity);
        }
        return ClientDynamicLightHandler.getItemModel(itemStack, null, null);
    }

    private static EmbeddedItemModel getItemModel(class_1799 itemStack, @Nullable class_1937 level, @Nullable class_1309 entity) {
        class_1087 model = ItemModelProvider.getItemModel(EnvironmentManager.getClient(), itemStack, level, entity, 0);
        EmbeddedItemModels itemModels = EmbeddedItemModels.of(itemStack);
        return itemModels.get(model);
    }
}

