/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.fabric.proxy;

import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.SleepModifier;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.event.common.ServerStartingEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerStoppedEvent;
import moe.plushie.armourers_workshop.init.platform.fabric.EnvironmentManagerImpl;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfig;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfigTracker;
import moe.plushie.armourers_workshop.init.platform.fabric.event.EntityLifecycleEvents;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class CommonProxyImpl
implements ModInitializer {
    public void onInitialize() {
        ArmourersWorkshop.init();
        EventBus.register(ServerStartingEvent.class, event -> EnvironmentManagerImpl.attach(event.getServer()));
        EventBus.register(ServerStoppedEvent.class, event -> EnvironmentManagerImpl.detach(event.getServer()));
        EnvironmentExecutor.willInit(EnvironmentType.COMMON);
        EnvironmentExecutor.willSetup(EnvironmentType.COMMON);
        UseBlockCallback.EVENT.register(this::onUseItemFirst);
        EntitySleepEvents.ALLOW_BED.register(this::onAllowBed);
        EntitySleepEvents.STOP_SLEEPING.register(this::onStopSleep);
        EntityLifecycleEvents.ALLOW_CLIMBING.register(this::onAllowClimbing);
        AttackBlockCallback.EVENT.register(this::onBlockBreakPre);
        EnvironmentExecutor.didInit(EnvironmentType.COMMON);
        FabricConfigTracker.INSTANCE.loadConfigs(FabricConfig.Type.COMMON, FabricLoader.getInstance().getConfigDir());
        EnvironmentExecutor.didSetup(EnvironmentType.COMMON);
    }

    public class_1269 onUseItemFirst(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 itemStack = player.method_5998(hand);
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)class_17922;
            return handler.useOnFirst(itemStack, new class_1838(player, hand, hitResult));
        }
        return class_1269.field_5811;
    }

    public class_1269 onAllowClimbing(class_1309 entity, class_2338 blockPos, class_2680 blockState) {
        IBlockHandler handler;
        if (entity.method_7325()) {
            return class_1269.field_5811;
        }
        class_2248 block = blockState.method_26204();
        if (block instanceof IBlockHandler && (handler = (IBlockHandler)block).isCustomLadder((class_1922)PropertyProvider.getLevel((class_1297)entity), blockPos, blockState, entity)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 onAllowBed(class_1309 entity, class_2338 sleepingPos, class_2680 blockState, boolean vanillaResult) {
        IBlockHandler handler;
        class_2248 block = blockState.method_26204();
        if (block instanceof IBlockHandler && (handler = (IBlockHandler)block).isCustomBed((class_1922)PropertyProvider.getLevel((class_1297)entity), sleepingPos, blockState, (class_1297)entity)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void onStopSleep(class_1309 entity, class_2338 sleepingPos) {
        IBlockHandler handler;
        class_1937 level = PropertyProvider.getLevel((class_1297)entity);
        class_2680 blockState = level.method_8320(sleepingPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof IBlockHandler && (handler = (IBlockHandler)block).isCustomBed((class_1922)level, sleepingPos, blockState, (class_1297)entity)) {
            SleepModifier.stopSleeping(entity, sleepingPos);
        }
    }

    public class_1269 onBlockBreakPre(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof IBlockHandler) {
            IBlockHandler handler = (IBlockHandler)block;
            class_1269 result = handler.attackBlock(level, pos, blockState, direction, player, hand);
            if (result == class_1269.field_21466) {
                return class_1269.field_5814;
            }
            if (result == class_1269.field_5812) {
                return class_1269.field_5811;
            }
            return result;
        }
        return class_1269.field_5811;
    }
}

