/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.CustomCollisionProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.EntityDimensions.CollisionShape;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.DataManager;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.utils.Scheduler;
import moe.plushie.armourers_workshop.core.utils.SkinUtils;
import moe.plushie.armourers_workshop.init.ModCommands;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.event.common.BlockEvent;
import moe.plushie.armourers_workshop.init.event.common.DataPackEvent;
import moe.plushie.armourers_workshop.init.event.common.EntityEvent;
import moe.plushie.armourers_workshop.init.event.common.PlayerEvent;
import moe.plushie.armourers_workshop.init.event.common.RegisterCommandsEvent;
import moe.plushie.armourers_workshop.init.event.common.RegisterDataPackEvent;
import moe.plushie.armourers_workshop.init.event.common.RegisterEntityAttributesEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerLevelAddEntityEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerLevelTickEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerStartedEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerStartingEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerStoppedEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerStoppingEvent;
import moe.plushie.armourers_workshop.init.event.common.ServerTickEvent;
import moe.plushie.armourers_workshop.init.network.UpdateContextPacket;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CommonProxy {
    public static void init() {
        CommonProxy.setup();
        CommonProxy.register();
    }

    private static void setup() {
        GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER, library::downloadSkin);
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER_PREVIEW, library::downloadPreviewSkin);
        ReplayManager.init();
    }

    private static void register() {
        EventBus.register(RegisterCommandsEvent.class, ModCommands::init);
        EventBus.register(RegisterDataPackEvent.class, event -> event.register(DataPackManager.byType(DataPackType.SERVER_DATA)));
        EventBus.register(RegisterEntityAttributesEvent.class, event -> {
            event.register((class_1299<? extends class_1309>)((class_1299)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), MannequinEntity.method_26827());
            event.register((class_1299<? extends class_1309>)((class_1299)((IEntityType)ModEntityTypes.SEAT.get()).get()), SeatEntity.method_26827());
        });
        EventBus.register(ServerStartingEvent.class, event -> {
            ModLog.debug("hello", new Object[0]);
            DataManager.getInstance().connect(EnvironmentManager.getSkinDatabaseDirectory());
            SkinLoader.getInstance().prepare(EnvironmentManager.getDistributionType(event.getServer()));
        });
        EventBus.register(ServerStartedEvent.class, event -> {
            ModLog.debug("init", new Object[0]);
            ModContext.init(event.getServer());
            SkinLoader.getInstance().start();
        });
        EventBus.register(ServerStoppingEvent.class, event -> {
            ModLog.debug("wait", new Object[0]);
            for (class_3218 level : event.getServer().method_3738()) {
                WorldUpdater.getInstance().drain((class_1937)level);
            }
            DataManager.getInstance().disconnect();
            SkinLoader.getInstance().stop();
        });
        EventBus.register(ServerStoppedEvent.class, event -> {
            ModLog.debug("bye", new Object[0]);
            ModContext.reset();
        });
        EventBus.register(ServerTickEvent.Pre.class, event -> Scheduler.SERVER.begin());
        EventBus.register(ServerTickEvent.Post.class, event -> Scheduler.SERVER.end());
        EventBus.register(DataPackEvent.Sync.class, event -> {
            class_1657 patt0$temp = event.player();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                ReplayManager.startRecording(event.player().method_5682(), event.player());
                NetworkManager.sendTo(UpdateContextPacket.sync((class_1657)player), player);
            }
        });
        EventBus.register(PlayerEvent.LoggingIn.class, event -> {
            ModLog.debug("welcome back {}", event.getPlayer().method_5820());
            ModHolidays.welcome(event.getPlayer());
            class_1657 patt0$temp = event.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                NetworkManager.sendWardrobeTo((class_1297)player, player);
            }
        });
        EventBus.register(PlayerEvent.LoggingOut.class, event -> {
            ModLog.debug("good bye {}", event.getPlayer().method_5820());
            SkinLibraryManager.getServer().remove(event.getPlayer());
            ReplayManager.stopRecording(event.getPlayer().method_5682(), event.getPlayer());
        });
        EventBus.register(PlayerEvent.Death.class, event -> {
            ModLog.debug("keep careful {}", event.getPlayer().method_5820());
            SkinUtils.dropAllIfNeeded(event.getPlayer());
        });
        EventBus.register(PlayerEvent.Clone.class, event -> {
            ModLog.debug("woa {}", event.getPlayer().method_5820());
            SkinUtils.copySkinWardrobe((class_1297)event.getOriginal(), (class_1297)event.getPlayer());
        });
        EventBus.register(PlayerEvent.Attack.class, event -> {
            IItemHandler handler;
            class_1269 result;
            class_1657 player = event.getPlayer();
            if (player == null || player.method_7325()) {
                return;
            }
            class_1799 itemStack = player.method_6047();
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof IItemHandler && (result = (handler = (IItemHandler)patt0$temp).attackLivingEntity(itemStack, player, event.getTarget())).method_23665()) {
                event.setCancelled(true);
            }
        });
        EventBus.register(PlayerEvent.StartTracking.class, event -> {
            EntityProfile entityProfile = ModEntityProfiles.getProfile(event.getTarget());
            if (entityProfile != null) {
                NetworkManager.sendWardrobeTo(event.getTarget(), (class_3222)event.getPlayer());
            }
        });
        EventBus.register(EntityEvent.ReloadSize.class, event -> {
            EntityCollisionShape collisionShape = CustomCollisionProvider.getCustomCollision(event.getEntity());
            if (collisionShape != null) {
                event.setSize(CollisionShape.withCollisionShape(event.getSize(), collisionShape));
            }
        });
        EventBus.register(ServerLevelTickEvent.Pre.class, event -> WorldUpdater.getInstance().tick((class_1937)event.getLevel()));
        EventBus.register(ServerLevelAddEntityEvent.class, event -> SkinUtils.copySkinFromOwner(event.getEntity()));
        EventBus.register(BlockEvent.Place.class, BlockUtils::snapshot);
        EventBus.register(BlockEvent.Break.class, BlockUtils::snapshot);
    }
}

