/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentExporter;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentImporter;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentSynchronizer;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.SkinUtils;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class AdvancedBuilderBlockEntity
extends UpdatableBlockEntity
implements SkinDocumentProvider {
    private class_238 renderBoundingBox;
    public final OpenVector3f carmeOffset = new OpenVector3f();
    public final OpenVector3f carmeRot = new OpenVector3f();
    public final OpenVector3f carmeScale = new OpenVector3f(1.0f, 1.0f, 1.0f);
    public OpenVector3f offset = new OpenVector3f(0.0f, 12.0f, 0.0f);
    private final SkinDocument document = new SkinDocument();

    public OpenVector3f getRenderOrigin() {
        class_2338 pos = this.method_11016();
        return new OpenVector3f((float)pos.method_10263() + this.offset.x() + 0.5f, (float)pos.method_10264() + this.offset.y() + 0.5f, (float)pos.method_10260() + this.offset.z() + 0.5f);
    }

    public AdvancedBuilderBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.document.addListener(new SkinDocumentListeners.Updater(this));
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.document.deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.document.serialize(serializer);
    }

    public void importToNode(String identifier, Skin skin, SkinDocumentNode node) {
        SkinDocumentSynchronizer synchronizer = new SkinDocumentSynchronizer(this, false);
        this.document.addListener(synchronizer);
        node.setSkin(new SkinDescriptor(identifier, skin.type()));
        this.document.removeListener(synchronizer);
        if (skin.itemTransforms() != null) {
            this.importToSettings(skin.itemTransforms(), node);
        }
    }

    private void importToSettings(OpenItemTransforms itemTransforms, SkinDocumentNode node) {
        Collection<String> overrideNames;
        OpenItemTransforms newItemTransforms = new OpenItemTransforms();
        if (this.document.itemTransforms() != null) {
            newItemTransforms.putAll(this.document.itemTransforms());
        }
        if (!(overrideNames = SkinUtils.getItemOverrides(node.type())).isEmpty()) {
            overrideNames.forEach(name -> itemTransforms.forEach((type, transform) -> newItemTransforms.put(name + ";" + type, transform)));
        } else {
            newItemTransforms.putAll(itemTransforms);
        }
        SkinDocumentSynchronizer synchronizer = new SkinDocumentSynchronizer(this, false);
        this.document.addListener(synchronizer);
        this.document.setItemTransforms(newItemTransforms);
        this.document.removeListener(synchronizer);
    }

    public void importToDocument(String identifier, Skin skin) {
        BlockUtils.performBatch(() -> {
            SkinDocumentImporter importer = new SkinDocumentImporter(this.document);
            this.document.reset();
            this.document.setItemTransforms(skin.itemTransforms());
            importer.execute(identifier, skin);
        });
    }

    public void exportFromDocument(class_3222 player, GameProfile profile) {
        SkinDocumentExporter exporter = new SkinDocumentExporter(this.document);
        exporter.setItemTransforms(this.document.itemTransforms());
        EnvironmentExecutor.runOnBackground(() -> () -> {
            try {
                Skin skin = exporter.execute((class_1657)player, profile);
                player.field_13995.execute(() -> {
                    String identifier = SkinLoader.getInstance().saveSkin("", skin);
                    SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
                    class_1799 itemStack = descriptor.asItemStack();
                    ABI.giveItem((class_1657)player, itemStack);
                });
            }
            catch (TranslatableException exception) {
                UserNotifications.sendErrorMessage(exception.getComponent(), (class_1657)player);
            }
        });
    }

    @Override
    public SkinDocument document() {
        return this.document;
    }

    @Override
    public class_238 getVisibleBox(class_2680 blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        float s = 16.0f;
        OpenVector3f origin = this.getRenderOrigin();
        OpenRectangle3f rect = new OpenRectangle3f(origin.x() - s / 2.0f, origin.y() - s / 2.0f, origin.z() - s / 2.0f, s, s, s);
        this.renderBoundingBox = new class_238((double)rect.minX(), (double)rect.minY(), (double)rect.minZ(), (double)rect.maxX(), (double)rect.maxY(), (double)rect.maxZ());
        return this.renderBoundingBox;
    }
}

