/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.util.Strings;

@Environment(value=EnvType.CLIENT)
public class ArmourerDisplaySetting
extends ArmourerBaseSetting
implements UITextFieldDelegate {
    protected final ArmourerBlockEntity blockEntity;
    private final HashMap<EntityTextureDescriptor.Source, String> defaultValues = new HashMap();
    private final UILabel inputType = new UILabel(new CGRect(10.0f, 85.0f, 160.0f, 10.0f));
    private final UITextField textField = new UITextField(new CGRect(10.0f, 95.0f, 120.0f, 16.0f));
    private final UICheckBox checkShowGuides = new UICheckBox(new CGRect(10.0f, 145.0f, 160.0f, 9.0f));
    private final UICheckBox checkShowModelGuides = new UICheckBox(new CGRect(10.0f, 160.0f, 160.0f, 9.0f));
    private final UICheckBox checkShowHelper = new UICheckBox(new CGRect(10.0f, 145.0f, 190.0f, 9.0f));
    private UIButton confirmView;
    private UIComboBox sourceComboView;
    private UIComboBox modelComboView;
    private EntityTextureDescriptor lastDescriptor = EntityTextureDescriptor.EMPTY;
    private EntityTextureDescriptor.Model lastTextureModel = EntityTextureDescriptor.Model.STEVE;
    private EntityTextureDescriptor.Source lastTextureSource = null;

    public ArmourerDisplaySetting(ArmourerMenu container) {
        super("armourer.displaySettings");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
        this.reloadData();
    }

    @Override
    public void init() {
        super.init();
        this.checkShowGuides.setTitle(this.getDisplayText("showGuide", new Object[0]));
        this.checkShowGuides.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerDisplaySetting::updateFlagValue);
        this.checkShowModelGuides.setTitle(this.getDisplayText("showModelGuide", new Object[0]));
        this.checkShowModelGuides.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerDisplaySetting::updateFlagValue);
        this.checkShowHelper.setTitle(this.getDisplayText("showHelper", new Object[0]));
        this.checkShowHelper.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerDisplaySetting::updateFlagValue);
        this.addSubview(this.checkShowGuides);
        this.addSubview(this.checkShowModelGuides);
        this.addSubview(this.checkShowHelper);
        this.inputType.setText(this.getDisplayText("label.username", new Object[0]));
        this.addSubview(this.inputType);
        String defaultValue = this.defaultValues.get((Object)this.lastTextureSource);
        this.textField.setMaxLength(1024);
        this.textField.setDelegate(this);
        if (Strings.isNotBlank((String)defaultValue)) {
            this.textField.setText(defaultValue);
        }
        this.addSubview(this.textField);
        this.confirmView = this.addCommonButton(10.0f, 120.0f, 100.0f, 20.0f, "set", this::submit);
        UILabel label2 = new UILabel(new CGRect(10.0f, 50.0f, 160.0f, 10.0f));
        label2.setText(this.getDisplayText("label.textureSource", new Object[0]));
        this.addSubview(label2);
        this.sourceComboView = this.addComboBox(10.0f, 60.0f, 80.0f, 14.0f, "textureSource", this.lastTextureSource, this::applyTextureSource);
        UILabel label1 = new UILabel(new CGRect(10.0f, 20.0f, 160.0f, 10.0f));
        label1.setText(this.getDisplayText("label.textureModel", new Object[0]));
        this.addSubview(label1);
        this.modelComboView = this.addComboBox(10.0f, 30.0f, 80.0f, 14.0f, "textureModel", this.lastTextureModel, this::applyTextureModel);
        this.reloadStatus();
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.submit(textField);
        return true;
    }

    @Override
    public void reloadData() {
        this.prepareDefaultValue();
        this.reloadStatus();
    }

    private void reloadStatus() {
        if (this.checkShowGuides == null) {
            return;
        }
        this.checkShowGuides.setSelected(this.blockEntity.isShowGuides());
        this.checkShowModelGuides.setSelected(this.blockEntity.isShowModelGuides());
        this.checkShowHelper.setSelected(this.blockEntity.isShowHelper());
        this.checkShowHelper.setHidden(!this.blockEntity.isUseHelper());
        if (this.lastTextureSource == EntityTextureDescriptor.Source.URL) {
            this.inputType.setText(this.getDisplayText("label.url", new Object[0]));
        } else {
            this.inputType.setText(this.getDisplayText("label.username", new Object[0]));
        }
    }

    private void prepareDefaultValue() {
        this.defaultValues.clear();
        if (this.blockEntity != null) {
            this.lastDescriptor = this.blockEntity.textureDescriptor();
            this.lastTextureModel = this.blockEntity.textureModel();
        }
        this.lastTextureSource = this.lastDescriptor.source();
        this.defaultValues.put(this.lastTextureSource, this.lastDescriptor.value());
    }

    private void submit(Object button) {
        this.textField.resignFirstResponder();
        this.confirmView.setEnabled(false);
        EntityTextureLoader.getInstance().loadTexture(this.textureDescriptor(), (texture, exception) -> {
            this.confirmView.setEnabled(true);
            if (texture == null) {
                UserNotificationCenter.showToast(exception, NSString.localizedString("common.text.error", new Object[0]), null);
                return;
            }
            EntityTextureDescriptor newValue = texture.descriptor();
            if (this.lastDescriptor.equals(newValue)) {
                return;
            }
            this.lastDescriptor = newValue;
            this.lastTextureSource = null;
            this.blockEntity.setTextureDescriptor(newValue);
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.TEXTURE_DESCRIPTOR.buildPacket(this.blockEntity, newValue));
            EntityTextureDescriptor.Source newTexutreSource = newValue.source();
            String newTextureValue = Objects.flatMap(newValue, EntityTextureDescriptor::value, "");
            this.defaultValues.put(newTexutreSource, newTextureValue);
            this.applyTextureSource(newTexutreSource);
        });
    }

    private void applyTextureSource(EntityTextureDescriptor.Source newValue) {
        if (this.lastTextureSource == newValue) {
            return;
        }
        this.defaultValues.put(this.lastTextureSource, this.textField.text());
        this.textField.setText(Objects.flatMap(this.defaultValues.get((Object)newValue), it -> it, ""));
        this.textField.resignFirstResponder();
        this.sourceComboView.setSelectedIndex(newValue.ordinal());
        this.lastTextureSource = newValue;
        this.reloadStatus();
    }

    private void applyTextureModel(EntityTextureDescriptor.Model newValue) {
        if (this.lastTextureModel == newValue) {
            return;
        }
        this.modelComboView.setSelectedIndex(newValue.ordinal());
        NetworkManager.sendToServer(UpdateArmourerPacket.Field.TEXTURE_MODEL.buildPacket(this.blockEntity, newValue));
        this.lastTextureModel = newValue;
    }

    private void updateFlagValue(UIControl sender) {
        int oldFlags = this.blockEntity.getFlags();
        this.blockEntity.setShowGuides(this.checkShowGuides.isSelected());
        this.blockEntity.setShowModelGuides(this.checkShowModelGuides.isSelected());
        this.blockEntity.setShowHelper(this.checkShowHelper.isSelected());
        int flags = this.blockEntity.getFlags();
        if (flags == oldFlags) {
            return;
        }
        this.blockEntity.setFlags(flags);
        NetworkManager.sendToServer(UpdateArmourerPacket.Field.FLAGS.buildPacket(this.blockEntity, flags));
    }

    private <T extends Enum<T>> UIComboBox addComboBox(float x, float y, float width, float height, String key, T defaultValue, Consumer<T> applier) {
        ArrayList<Enum> values = Collections.newList((Enum[])defaultValue.getClass().getEnumConstants());
        UIComboBox comboView = new UIComboBox(new CGRect(x, y, width, height));
        comboView.setSelectedIndex(values.indexOf(defaultValue));
        comboView.reloadData(Collections.compactMap(values, value -> {
            String name = value.name().toLowerCase();
            return new UIComboItem(this.getDisplayText(key + "." + name, new Object[0]));
        }));
        comboView.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, e) -> {
            int newValue = ((UIComboBox)e).selectedIndex();
            applier.accept((Enum)Objects.unsafeCast((Enum)values.get(newValue)));
        });
        this.addSubview(comboView);
        return comboView;
    }

    private UIButton addCommonButton(float x, float y, float width, float height, String key, Consumer<UIControl> handler) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setTitle(this.getDisplayText(key, new Object[0]), 7);
        button.setTitleColor(UIColor.WHITE, 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, e) -> handler.accept((UIControl)e));
        this.addSubview(button);
        return button;
    }

    private EntityTextureDescriptor textureDescriptor() {
        String value = this.textField.text();
        if (Strings.isNotEmpty((CharSequence)value)) {
            EntityTextureDescriptor.Source userType = EntityTextureDescriptor.Source.values()[this.sourceComboView.selectedIndex()];
            if (userType == EntityTextureDescriptor.Source.URL) {
                return EntityTextureDescriptor.fromURL(value);
            }
            if (userType == EntityTextureDescriptor.Source.USER) {
                return EntityTextureDescriptor.fromName(value);
            }
        }
        return EntityTextureDescriptor.EMPTY;
    }
}

