/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerBaseSkinPanel;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ArmourerWingsSkinPanel
extends ArmourerBaseSkinPanel {
    public ArmourerWingsSkinPanel(SkinProperties skinProperties) {
        super(skinProperties);
    }

    @Override
    public void init() {
        super.init();
        this.addLabel(0, 0, this.getDisplayText("label.idleSpeed", new Object[0]));
        this.addSliderBox(0, 0, 154, 10, 200.0, 10000.0, "ms", SkinProperty.WINGS_IDLE_SPEED);
        this.addLabel(0, 0, this.getDisplayText("label.flyingSpeed", new Object[0]));
        this.addSliderBox(0, 0, 154, 10, 200.0, 10000.0, "ms", SkinProperty.WINGS_FLYING_SPEED);
        this.addLabel(0, 0, this.getDisplayText("label.maxAngle", new Object[0]));
        this.addSliderBox(0, 0, 154, 10, -180.0, 180.0, "\u00b0", SkinProperty.WINGS_MAX_ANGLE);
        this.addLabel(0, 0, this.getDisplayText("label.minAngle", new Object[0]));
        this.addSliderBox(0, 0, 154, 10, -180.0, 180.0, "\u00b0", SkinProperty.WINGS_MIN_ANGLE);
        this.addCheckBox(0, 2, SkinProperty.WINGS_MATCHING_POSE);
        this.addMovementList(0, 2, 50, 16, SkinProperty.WINGS_MOVMENT_TYPE);
    }

    protected UIComboBox addMovementList(int x, int y, int width, int height, SkinProperty<String> property) {
        int selectedIndex = 0;
        SkinProperty.MovementType selectedMovementType = SkinProperty.MovementType.valueOf(this.skinProperties.get(property));
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (SkinProperty.MovementType movementType : SkinProperty.MovementType.values()) {
            NSString name = NSString.localizedTableString("movmentType", movementType.name().toLowerCase(), new Object[0]);
            UIComboItem item = new UIComboItem(name);
            if (movementType == selectedMovementType) {
                selectedIndex = items.size();
            }
            items.add(item);
        }
        UIComboBox comboBox = new UIComboBox(new CGRect(this.cursorX + (float)x, this.cursorY + (float)y, width, height));
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.reloadData(items);
        comboBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, box) -> {
            int newValue = ((UIComboBox)box).selectedIndex();
            SkinProperty.MovementType newMovementType = SkinProperty.MovementType.values()[newValue];
            self.skinProperties.put(property, newMovementType.name());
            this.apply();
        });
        this.addSubview(comboBox);
        return comboBox;
    }
}

