/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModSounds;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2561;
import net.minecraft.class_3414;

public class ColorNoiseToolItem
extends AbstractColoredToolItem
implements IBlockPaintViewer {
    public ColorNoiseToolItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
        builder.accept(PaintingToolOptions.INTENSITY);
    }

    @Override
    public IPaintToolAction createPaintToolAction(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        Integer intensity = ToolAPI.get(itemStack, PaintingToolOptions.INTENSITY);
        return new CubePaintingEvent.NoiseAction(intensity, false);
    }

    @Override
    public void appendSettingHoverText(class_1799 itemStack, List<class_2561> tooltips) {
        Integer intensity = ToolAPI.get(itemStack, PaintingToolOptions.INTENSITY);
        tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.intensity", intensity));
        super.appendSettingHoverText(itemStack, tooltips);
    }

    @Override
    public IRegistryHolder<class_3414> getItemSoundEvent(class_1838 context) {
        return ModSounds.NOISE;
    }
}

