/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModSounds;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3414;

public class PaintRollerItem
extends PaintbrushItem {
    public PaintRollerItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        super.createToolProperties(builder);
        builder.accept(PaintingToolOptions.RADIUS);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        class_2338 pos = context.method_8037();
        Integer radius = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS);
        return CubeSelector.plane(pos, radius, this.shouldUseFullMode(context));
    }

    @Override
    public void appendSettingHoverText(class_1799 itemStack, List<class_2561> tooltips) {
        Integer radius = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS);
        tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.area", radius * 2 - 1, radius * 2 - 1, 1));
        super.appendSettingHoverText(itemStack, tooltips);
    }

    @Override
    public void playParticle(class_1838 context) {
    }

    @Override
    public IRegistryHolder<class_3414> getItemSoundEvent(class_1838 context) {
        return ModSounds.PAINT;
    }
}

